(define-module (type ahttpd-cert-field)
    :use-module (alterator woo)
    :export (type))

(define *latin-string-regex-str* "^[a-zA-Z_[:space:]0-9-]+$")
(define *latin-string-regex* (make-regexp *latin-string-regex-str* regexp/extended))

(define (type v _)
  (or (and (string? v) (string-null? v))
      (and (string? v) (regexp-exec *latin-string-regex* v))
      (type-error (_ "only digits and latin letters allowed" "alterator-ahttpd"))))
