(define-module (type bacula-password)
    :use-module (alterator woo)
    :export (type))

(define *password-regex-str* "^[^[:space:]\"{}\\\\]*$")

(define password-regex (make-regexp *password-regex-str* regexp/extended))

(define (type v _)
  (or (and (string? v) (string-null? v))
      (and (string? v) (regexp-exec password-regex v))
      (type-error (_ "password contains illegal characters" "alterator-bacula"))))
