(define-module (type e-mail)
    :use-module (alterator woo)
    :export (type))

(define *address-regex-str* "^([_a-zA-Z0-9-]+(\\.[_a-zA-Z0-9-]+)*)@([a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*)$")

(define *address-regex* (make-regexp *address-regex-str* regexp/extended))

(define (type v _)
  (or (and (string? v) (string-null? v))
      (and (string? v) (regexp-exec *address-regex* v))
      (type-error (_ "invalid e-mail address"))))
