(define-module (type hostname)
    :use-module (alterator woo)
    :export (
             hostname-regex
             type))

(define *hostname-regex-str* "^[.a-zA-Z0-9_-]*$")

(define hostname-regex (make-regexp *hostname-regex-str* regexp/extended))

(define (type v _)
  (or (and (string? v) (string-null? v))
      (and (string? v) (regexp-exec hostname-regex v))
      (type-error (_ "only latin letters, digits, '-', '.', and '_' allowed"))))
