(define-module (type ipv4-address)
    :use-module (alterator woo)
    :export (
	     ipv4-address-regex-str
             ipv4-address-regex
             type))

(define ipv4-address-regex-str "([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])([.]([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9+]|25[0-5])){3}")
(define ipv4-address-regex-str2 (string-append "^" ipv4-address-regex-str "$"))

(define ipv4-address-regex (make-regexp ipv4-address-regex-str2 regexp/extended))

(define (type v _)
  (or (and (string? v) (string-null? v))
      (and (string? v) (regexp-exec ipv4-address-regex v))
      (type-error (_ "invalid IP address"))))
