(define-module (type ipv4-addrwmask)
    :use-module (alterator woo)
    :use-module ((type ipv4-address) :select (ipv4-address-regex-str))
    :export (type))

(define *ipv4-addrwmask-regex-str* (string-append "^" ipv4-address-regex-str "/([1-9]|[12][0-9]|3[0-1])$"))

(define *ipv4-addrwmask-regex* (make-regexp *ipv4-addrwmask-regex-str* regexp/extended))

(define (type v _)
  (or (and (string? v) (string-null? v))
      (and (string? v) (regexp-exec *ipv4-addrwmask-regex* v))
      (type-error (_ "invalid IP with MASK specification"))))

