(define-module (type ipv4-network-list)
    :use-module (srfi srfi-1)
    :use-module (srfi srfi-13)
    :use-module (srfi srfi-14)
    :use-module (alterator woo)
    :use-module ((type ipv4-network) :select (*ipv4-network-regex*))
    :export (type))

(define (type v _)
  (or (and (string? v) (string-null? v))
      (and (string? v)
           (every (lambda(x) (regexp-exec *ipv4-network-regex* x))
                  (string-tokenize v (char-set-complement char-set:blank))))
      (type-error (_ "invalid IP network list"))))
