(define-module (type ldap-account-name)
    :use-module (alterator woo)
    :export (type))

(define *account-regex-str* "^[a-z][\.a-z0-9_-]*$")

(define *account-regex* (make-regexp *account-regex-str* regexp/extended))

(define (type v _)
  (or (and (string? v) (string-null? v))
      (and (string? v) (regexp-exec *account-regex* v))
      (type-error (_ "only small latin letters, digits dot and '_' allowed"))))
