(define-module (type ldap-group-name)
    :use-module (alterator woo)
    :export (type))

(define *account-regex-str* "^[A-Za-z][\. a-zA-Z0-9_-]*$")

(define *account-regex* (make-regexp *account-regex-str* regexp/extended))

(define (type v _)
  (or (and (string? v) (string-null? v))
      (and (string? v) (regexp-exec *account-regex* v))
      (type-error (_ "only latin letters, digits, dot, space and '_' allowed"))))
