(define-module (alterator type ssl-cert-field)
			   :use-module (alterator woo)
			   :export (type))

(define *latin-string-regex-str* "^[a-zA-Z_[:space:][:punct:]0-9-]+$")
(define *latin-string-regex* (make-regexp *latin-string-regex-str* regexp/extended))

(define (type v _)
  (or (and (string? v) (string-null? v))
	  (and (string? v) (regexp-exec *latin-string-regex* v))
	  (type-error (_ "only digits, punctuation and latin letters allowed" "alterator-sslkey"))))
