(define-module (type system-computer-name)
    :use-module (alterator woo)
    :export (type))

(define *system-computer-name-regex-str* "^[a-zA-Z0-9_-]*$")

(define system-computer-name-regex (make-regexp *system-computer-name-regex-str* regexp/extended))

(define (type v _)
  (or (and (string? v) (string-null? v))
      (and (string? v) (regexp-exec system-computer-name-regex v))
      (type-error (_ "only latin letters, digits, '-', and '_' allowed"))))
