(define-module (type tcp-port)
    :use-module (alterator woo)
    :export (type))

(define (valid-range? v)
  (and (number? v) (< -1 v 65535)))

(define (type v _)
  (or (and (string? v) (string-null? v))
      (and (string? v) (valid-range? (string->number v)))
      (and (number? v) (valid-range? v))
      (type-error (_ "invalid TCP port"))))

