(define-module (type telephone-number)
    :use-module (alterator woo)
    :export (type))

;; according E.123 telephone number can be any latin1 string with additional space and control characters
(define *telephone-number-regex-str* "^[+#*a-z0-9[:space:]-]+")
(define *telephone-number-regex* (make-regexp *telephone-number-regex-str* regexp/extended))

(define (type v _)
  (or (and (string? v) (string-null? v))
      (and (string? v) (regexp-exec *telephone-number-regex* v))
      (type-error (_ "invalid telephone number"))))
