(define-module (type time)
    :use-module (alterator woo)
    :export (type))

(define *time-regex-str* "^([01][0-9]|2[0-3])(:[0-5][0-9]){2}$")
(define *time-regex* (make-regexp *time-regex-str* regexp/extended))

(define (type v _)
  (or (and (string? v) (regexp-exec *time-regex* v))
      (type-error (_ "time should be in HH:MM:SS format"))))
