(define-module (ui ahttpd acl ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :export (init))

(define (ui-read)
    (form-update-enum "user" (woo-list "/ahttpd-acl/users" 'desktopfile (form-value "desktopfile")))
    (form-update-enum "new_user" (woo-list "/ahttpd-acl/unused_users" 'desktopfile (form-value "desktopfile"))))

(define (ui-add)
  (let ((new_user (form-value "new_user")))
    (and new_user
	 (catch/message
	   (lambda()
	     (woo-write "/ahttpd-acl"
			'new #t
			'desktopfile (form-value "desktopfile")
			'new_user new_user)
	     (ui-read))))))

(define (ui-reload)
  (form-replace "/ahttpd/server/reload"))

(define (ui-del)
    (catch/message
	(lambda()
	    (woo-write "/ahttpd-acl"
	               'delete #t
	               'desktopfile (form-value "desktopfile")
	               'user (form-value "user"))
	    (ui-read))))

(define (init)
    (ui-read)
    (form-bind "add_button" "click" ui-add)
    (form-bind "del_button" "click" ui-del)
    (form-bind "reload_button" "click" ui-reload))
