(define-module (ui ahttpd help ajax)
    :use-module (srfi srfi-1)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :use-module (alterator ahttpd) ;; for uri-prefix?
    :use-module (alterator menu)
    :export (ui))

(define *menu-item-list* (menu-list-item))

(define (current-module? item url)
  (uri-prefix? (menu-item-ref item 'uri) url))

(define (module-item-topic url)
  (any (lambda(x) (and (current-module? x url) (woo-get-option x 'help)))
        *menu-item-list*))

(define (ui)
  (let* ((url (form-value "url"))
	 (topic (or (module-item-topic url) "acc-html")))
    (ui-file "url"
	     (woo-read-first "/help"
			     'topic topic
			     'language (form-value "language")))))

