(define-module (ui ahttpd power ajax)
  :use-module (alterator ajax)
  :use-module (alterator woo)
  :export (init))

(define (ui-read)
  (form-update-value "shutdown_type" "none")
  (form-update-value-list
    '("shutdown_time" "shutdown_cron")
    (woo-call "/ahttpd-power/read_cron")))

(define (ui-poweroff)
  (woo-call "/ahttpd-power/poweroff"))

(define (ui-reboot)
  (woo-call "/ahttpd-power/reboot"))

(define (ui-write)
  (catch/message
    (lambda()
      (case (string->symbol (or (form-value "shutdown_type") ""))
	((poweroff)
	 (form-update-visibility "poweroff_message" #f)
	 (and (form-confirm (_ "Are you really want to shutdown system?") (_"Question") (_ "Yes") (_ "No"))
	      (begin (form-update-visibility "poweroff_message" #t)
	             (form-set-timeout ui-poweroff 1))))
	((reboot)
	 (form-update-visibility "reboot_message" #f)
	 (and (form-confirm (_ "Are you really want to reboot system?") (_ "Question") (_ "Yes") (_ "No"))
	      (begin (form-update-visibility "reboot_message" #t)
	             (form-set-timeout ui-reboot 1))))
	(else
	  (apply
	    woo-call
	    "/ahttpd-power/write_cron"
	    'language (form-value "language")
	    (form-value-list '("shutdown_time" "shutdown_cron"))))))))

(define (init)
  (ui-read)
  (form-bind "apply_button" "click" ui-write)
  (form-bind "reset_button" "click" ui-read))
