(define-module (ui ahttpd server ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :export (init))

(define (ui-read)
  (form-update-value-list
                    '("port" "listen" "log_mode"
                      "CN" "C" "L" "O" "OU")
                     (woo-read-first "/ahttpd-server")))

(define (on-reload)
  (form-replace "/ahttpd/server/reload"))

(define (on-tls)
  (form-replace "/sslkey/generate" 'name "ahttpd"))

(define (on-apply)
  (catch/message
    (lambda()
      (apply woo-write "/ahttpd-server" (form-value-list '("language" "port" "listen" "log_mode")))
      (ui-read))))

(define (init)
  (form-update-enum "log_mode"
                    (woo-list "/ahttpd-server/avail_log_mode" 'language (form-value "language")))
  (ui-read)
  (form-bind "reload_button" "click" on-reload)
  (form-bind "apply_button" "click" on-apply)
  (form-bind "tls_button" "click" on-tls))
