(define-module (ui bacula client-backup archive ajax)
    :use-module (alterator str)
    :use-module (alterator algo)
    :use-module (alterator ajax)
    :use-module (alterator effect)
    :use-module (alterator woo)
    :export (init))

(define staddress "")

(define (ui-advanced)
  (form-update-visibility "advanced" (form-value "restore_advanced")))

(define (ui-action . value)
  (let ((value (if (pair? value) (car value) (form-value "action"))))
    (form-update-activity
      '("restore_path" "restore_date" "restore_advanced" "target_client" "target_path")
      (string=? value "restore"))))

(define (ui-restore jobid)
  (let* ((done (lambda() (form-set-timeout (lambda() (form-update-visibility "restore_message" #f)) 1)))
         (next (lambda() (form-set-timeout (lambda() (ui-restore jobid)) 1)))
	 (data (cond-car (woo "client_status" "/bacula-client-backup" 'name (form-value "name") 'jobid jobid)))
	 (job_status (string->symbol (woo-get-option data 'job_status))))
    (case job_status
      ((T e)
       (form-update-value "restore_message" (_ "Restore completed"))
       (done))
      ((B E f A)
       (form-update-value "restore_message" (_ "Restore failed, see logs for details")))
      ((C)
       (form-update-value "restore_message" (_ "Starting restore..."))
       (next))
      ((R D F S m M s j c d p a i)
       (form-update-value "restore_message" (format #f "~A ~A ..." (_ "Restoring file") (woo-get-option data 'job_progress)))
       (next)))))

(define (ui-ok)
  (catch/message
    (lambda()
      (let ((action (form-value "action"))
	    (name (form-value "name")))
	(cond
	  ((string=? action "backup")
	   (woo "client_backup" "/bacula-client-backup" 'name name)
	   (ui-read2))
	  ((string=? action "clear")
	   (if (form-confirm (string-append (_ "Do you really want clear all backups for client")
	                                    " "
					    name
	                                    " ?"))
	     (begin
	       (woo "client_clear" "/bacula-client-backup" 'name name)
	       (ui-read2))))
	  ((string=? action "restore")
	   (let ((result (cond-car (woo "client_restore"
					"/bacula-client-backup"
					'name name
					'restore_date (form-value "restore_date")
					'restore_path (form-value "restore_path")
					'target_client (form-value "target_client")
					'target_path (form-value "target_path")))))
	     (form-update-visibility "restore_message" #t)
	     (ui-restore (woo-get-option result 'jobid)))))))))

(define (ui-write)
  (catch/message
    (lambda()
      (apply woo-write
	     "/bacula-client-backup/archive"
	     (form-value-list '("retention" "name" "language")))
      (ui-read))))

(define (ui-read . name)
  (catch/message
    (lambda()
      (let ((name (if (pair? name) (car name) (form-value "name"))))
	(form-update-value-list
	  '("retention" "restore_date")
	  (woo-read-first "/bacula-client-backup/archive" 'name name))
	(form-update-value "action" "backup")
	(form-update-value "target_client" name)
	(form-update-value "target_path" "")
	(ui-action "backup")))))

(define (ui-read2)
  (form-update-value-list
      (woo-read-first "/bacula-status" 'language (form-value "language")))
  (update-effect)
  (form-update-enum "backups" (woo-list "/bacula-client-backup/backup" 'language (form-value "language"))))

(define (ui-read2/timeout)
  (ui-read2)
  (form-set-timeout ui-read2/timeout 4))

(define (ui-list . name)
  (let* ((data (woo-list "/bacula-client-backup/client"))
	 (name (or (and (pair? name) (not-empty-string? (car name)) (car name))
		   (and (pair? data) (woo-get-option (car data) 'name)))))
    (or (pair? data) (throw 'no-clients-error))
    (form-update-enum "name" data)
    (form-update-enum "target_client" data)
    (and name (form-update-value "name" name))
    (and name (ui-read name))))

(define (check_address)
  (let* ((data (woo-read "/bacula-director/" )))
	(set! staddress (woo-get-option (car data) 'storage_address)))
  (if (equal? staddress "" )
	(begin
	(form-update-visibility "nostatic_page" #t)
	(form-update-visibility "static_page" #f))
))

(define (init)
(check_address)
 (catch/message
   (lambda()
     (catch 'no-clients-error
	    (lambda()

	      (effect-hide "director_running" "director_running" "")
	      (effect-hide "storage_running" "storage_running" "")
	      (effect-hide "director_current_box" "director_current" "-")
	      (effect-hide "storage_current_box" "storage_current" "-")
	      (effect-show "director_last_box" "director_current" "-")
	      (effect-show "storage_last_box" "storage_current" "-")
	      (init-effect)



	      (ui-read2/timeout)
	      (form-update-enum "retention" (woo-list "/bacula-client-backup/retention" 'language (form-value "language")))
	      (ui-list (form-value "client"))


	      (form-bind "name" "change" ui-read)
	      (form-bind "update" "click" ui-write)
	      (form-bind "restore_advanced" "change" ui-advanced)

	      (form-bind "action" "change" ui-action)
	      (form-bind "ok" "click" ui-ok)
	      (form-update-visibility '("archive_page") #t))
	    (lambda args
	      (form-update-visibility '("noarchive_page") #t))))))
