(define-module (ui bacula client-backup client ajax)
    :use-module (alterator str)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :export (init))
    
(define staddress "")

;;; filelist
(define (ui-filelist-read type name)
  (form-update-enum type (woo "filelist_list" "/bacula-client-backup" 'type type 'name name)))

(define (ui-filelist-commit type name)
  (woo "filelist_commit" "/bacula-client-backup" 'type type 'name name))

(define (ui-filelist-reset type name)
  (woo "filelist_reset" "/bacula-client-backup" 'type type 'name name))

(define (ui-filelist-add type new_path)
  (let ((name (form-value "name")))
    (and (string? name) (string? new_path)
	 (catch/message
	   (lambda()
	     (woo "filelist_add"
		  "/bacula-client-backup"
		  'name name
		  'type type
		  'new_path new_path)
	     (ui-filelist-read type name))))))

(define (ui-filelist-del type path)
  (let ((name (form-value "name")))
    (and (string? name) (string? path)
	 (catch/message
	   (lambda()
	     (woo "filelist_del"
		  "/bacula-client-backup"
		  'name name
		  'type type
		  'path path)
	     (ui-filelist-read type name))))))

(define (ui-include-add)
  (let ((new_include (form-value "new_include")))
    (ui-filelist-add "include" new_include)
    (form-update-value "new_include" "")))

(define (ui-include-del)
  (ui-filelist-del "include" (form-value "include")))

(define (ui-exclude-add)
  (let ((new_exclude (form-value "new_exclude")))
    (ui-filelist-add "exclude" new_exclude)
    (form-update-value "new_exclude" "")))

(define (ui-exclude-del)
  (ui-filelist-del "exclude" (form-value "exclude")))

;;; account

(define (ui-read . name)
  (form-update-visibility "update_message" #f)
  (let ((name (if (pair? name) (car name) (form-value "name"))))
    (and (string? name)
	 (begin
	   (form-update-value "password" "")
	   (form-update-value "config" name)
	   (ui-filelist-reset "include" name)
	   (ui-filelist-reset "exclude" name)
	   (ui-filelist-read "include" name)
	   (ui-filelist-read "exclude" name)
	   (form-update-value-list
	     '("address" "port")
	     (woo-read-first "bacula-client-backup" 'name name))))))

(define (ui-list . name)
  (let* ((data (woo-list "/bacula-client-backup/client"))
	 (name (or (and (pair? name) (not-empty-string? (car name)) (car name))
		   (and (pair? data) (woo-get-option (car data) 'name)))))
    (form-update-enum "name" data)
    (form-update-visibility '("client_page") (pair? data))
    (and name
	 (begin (form-update-value "name" name)
		(ui-read name)))))

(define (ui-delete)
  (let ((name (form-value "name")))
    (if   (and (not-empty-string? name)
	       (form-confirm (string-append (_ "Do you really want to delete client")
					    " "
					    name
					    " ?")
			     (_ "Question")
			     (_ "Yes")
			     (_ "No")))
      (catch/message
	(lambda()
	  (woo "client_del" "/bacula-client-backup" 'name name 'language (form-value "language"))
	  (ui-list))))))

(define (ui-new)
  (let ((new_name (form-value "new_name")))
    (if (not-empty-string? new_name)
      (catch/message
	(lambda()
	  (woo "client_add" "/bacula-client-backup" 'new_name new_name 'template (form-value "template") 'language (form-value "language"))
	  (form-update-value "new_name" "")
	  (ui-list new_name))))))

(define (ui-write)
  (let ((name (form-value "name")))
    (if (not-empty-string? name)
      (catch/message
	(lambda()
	  (form-update-visibility "update_message" #f)
	  (apply woo-write  "/bacula-client-backup"
		 (form-value-list '("name" "address" "port" "password" "language")))
	  (ui-filelist-commit "include" name)
	  (ui-filelist-commit "exclude" name)
	  (ui-read name)
	  (form-update-visibility "update_message" #t))))))

(define (check_address)
  (let* ((data (woo-read "/bacula-director/" )))
  (set! staddress (woo-get-option (car data) 'storage_address)))
    (if (equal? staddress "" )
    (begin
    (form-update-visibility "nostatic_page" #t)
    (form-update-visibility "static_page" #f))
    ))

(define (init)
(check_address)
  (ui-list (form-value "client"))

  (form-update-enum "template" (woo-list "/bacula-client-backup/template" 'language (form-value "language")))

  (form-bind "name" "change" ui-read)

  (form-bind "delete_button" "click" ui-delete)
  (form-bind "apply_button" "click" ui-write)
  (form-bind "new_button" "click" ui-new)

  (form-bind "include_add_button" "click" ui-include-add)
  (form-bind "include_del_button" "click" ui-include-del)

  (form-bind "exclude_add_button" "click" ui-exclude-add)
  (form-bind "exclude_del_button" "click" ui-exclude-del))
