(define-module (ui bacula client-backup schedule ajax)
    :use-module (alterator str)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :export (init))

(define staddress "")

(define (ui-read . name)
  (let ((name (if (pair? name) (car name) (form-value "name"))))
    (form-update-value-list
      '("schedule_status" "schedule_time")
      (if name (woo-read-first "bacula-client-backup" 'name name) '("/bacula-client-backup")))))

(define (ui-read2)
  (form-update-enum "schedule" (woo-list "/bacula-client-backup/schedule")))

(define (ui-list . name)
  (let* ((data (woo-list "/bacula-client-backup/client"))
	 (name (or (and (pair? name) (not-empty-string? (car name)) (car name))
		   (and (pair? data) (woo-get-option (car data) 'name)))))
    (or (pair? data) (throw 'no-clients-error))
    (form-update-enum "name" data)
    (and name (form-update-value "name" name))
    (ui-read name)))

(define (ui-write)
  (let ((name (form-value "name")))
    (if (not-empty-string? name)
      (catch/message
	(lambda()
	  (apply woo-write  "/bacula-client-backup"
		 (form-value-list '("name" "schedule_status" "schedule_time" "language")))
	  (ui-read2))))))

(define (check_address)
  (let* ((data (woo-read "/bacula-director/" )))
        (set! staddress (woo-get-option (car data) 'storage_address)))
  (if (equal? staddress "" )
        (begin
        (form-update-visibility "nostatic_page" #t)
        (form-update-visibility "static_page" #f))
))

(define (init)
(check_address)
  (catch 'no-clients-error
	 (lambda()
	   (ui-read2)
	   (ui-list (form-value "client"))
	   (form-bind "name" "change" ui-read)
	   (form-bind "apply_button" "click" ui-write)
	   (form-update-visibility '("schedule_page") #t))
	 (lambda args
	   (form-update-visibility '("noschedule_page") #t))))
