(define-module (ui bacula director ajax)
	       :use-module (alterator ajax)
	       :use-module (alterator woo)
	       :export (init))

(define (ui-write)
  (form-update-visibility "director_message" #f)
  (catch/message
    (lambda()
      (apply woo-write "/bacula-director"
	     'language (form-value "language")
	     (form-value-list '("director_name" "storage_address")))
      (form-update-visibility "director_message" #t)
      (ui-read))))

(define (ui-read)
  (catch/message
    (lambda()
      (form-update-value-list
	'("storage_address" "director_name")
	(woo-read-first "/bacula-director")))))

(define (init)
  (ui-read)
  (form-bind "apply_button" "click" ui-write))
