(define-module (ui bacula local-backup advanced ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :export (init))

(define staddress "")                                                                                             
                                                                                                                  
(define (check_address)                                                                                           
  (let* ((data (woo-read "/bacula-director/" )))                                                                  
  (set! staddress (woo-get-option (car data) 'storage_address)))                                                  
    (if (equal? staddress "" )                                                                                    
    (begin                                                                                                        
    (form-update-visibility "nostatic_page" #t)                                                                   
    (form-update-visibility "static_page" #f))                                                                    
    )) 

(define (ui-return)
  (form-replace "/bacula/local-backup"))

(define (ui-read)
  (form-update-enum "jobs" (woo-list "/bacula-local-backup/jobs" 'language (form-value "language"))))

(define (ui-read/timeout)
  (ui-read)
  (form-set-timeout ui-read/timeout 2))

(define (ui-read2)
  (form-update-value "new_exclude" "")
  (form-update-enum "exclude" (woo-list "/bacula-local-backup/exclude")))

(define (ui-backup)
  (catch/message
    (lambda()
      (woo "backup" "/bacula-local-backup" 'language (form-value "language"))
      (ui-read))))

(define (ui-cancelbackup)
  (catch/message
    (lambda()
      (woo "cancelbackup" "/bacula-local-backup" 'language (form-value "language"))
      (ui-read))))

(define (ui-add)
  (catch/message
    (lambda()
      (woo "exclude_add" "/bacula-local-backup" 'language (form-value "language") 'new_exclude (form-value "new_exclude"))
      (ui-read2))))

(define (ui-del)
  (catch/message
    (lambda()
      (woo "exclude_del" "/bacula-local-backup" 'language (form-value "language") 'exclude (form-value "exclude"))
      (ui-read2))))

(define (init)
(check_address)
  (ui-read/timeout)
  (ui-read2)
  (form-bind "add" "click" ui-add)
  (form-bind "del" "click" ui-del)
  (form-bind "return" "click" ui-return)
  (form-bind "backup" "click" ui-backup)
  (form-bind "cancelbackup" "click" ui-cancelbackup))
