(document:surround "/std/frame")

;;; UI

width 650
height 500

(gridbox
  columns "100;0"
  margin "10"

  (label text (_ "Created backups:") colspan 2)
  (listbox
    colspan 2
    name "jobs"
    columns 2
    header (vector (_ "Creation date") (_ "Creation result"))
    row '#((creation_date . "") (creation_result . "")))

  (hbox
    colspan 2
    (button name "backup" align "left" text (_ "Run backup now"))
    (label text "   ")
    (button name "cancelbackup" align "right" text (_ "Cancel active jobs")))

  (label colspan 2)

  (label text (_ "Do not backup:") colspan 2)

  (listbox name "exclude")
  (button align "top" name "del" text (_ "Delete"))

  (hbox
    colspan "2"
    align "left"
    (label text (_ "New path:") align "left" nameref "new_exclude")
    (edit name "new_exclude")
    (button name "add" text (_ "Add")))

  (label colspan 2)
  (button align "left" name "return" text (_ "Return")))

;;; functions

(define (ui-return)
  (document:end))

(define (ui-read)
  (form-update-enum "jobs" (woo-list "/bacula-local-backup/jobs")))

(define (ui-read2)
  (form-update-value "new_exclude" "")
  (form-update-enum "exclude" (woo-list "/bacula-local-backup/exclude")))

(define (ui-backup)
  (catch/message
    (lambda()
      (woo "backup" "/bacula-local-backup" 'language (form-value "language"))
      (ui-read))))

(define (ui-cancelbackup)
  (catch/message
    (lambda()
      (woo "cancelbackup" "/bacula-local-backup" 'language (form-value "language"))
      (ui-read))))

(define (ui-add)
  (catch/message
    (lambda()
      (woo "exclude_add" "/bacula-local-backup" 'language (form-value "language") 'new_exclude (form-value "new_exclude"))
      (ui-read2))))

(define (ui-del)
  (catch/message
    (lambda()
      (woo "exclude_del" "/bacula-local-backup" 'language (form-value "language") 'exclude (form-value "exclude"))
      (ui-read2))))

(define (init)
  (ui-read)
  (ui-read2)
  (form-bind "add" "click" ui-add)
  (form-bind "del" "click" ui-del)
  (form-bind "return" "click" ui-return)
  (form-bind "backup" "click" ui-backup)
  (form-bind "cancelbackup" "click" ui-cancelbackup))

(document:root (when loaded (init)))
