(define-module (ui bacula local-backup ajax)
    :use-module (alterator ajax)
    :use-module (alterator algo)
    :use-module (alterator woo)
    :export (init))

(define staddress "")

(define (check_address)                                                                                           
  (let* ((data (woo-read "/bacula-director/" )))                                                                  
  (set! staddress (woo-get-option (car data) 'storage_address)))                                                  
    (if (equal? staddress "" )                                                                                    
    (begin                                                                                                        
    (form-update-visibility "nostatic_page" #t)                                                                   
    (form-update-visibility "static_page" #f))                                                                    
    ))

(define (ui-advanced)
  (form-replace "/bacula/local-backup/advanced"))

(define (ui-disk)
  (form-replace "/bacula/local-backup/disk"))

(define (ui-save)
  (catch/message
    (lambda()
      (woo-write "/bacula-local-backup"
                 'language (form-value "language")
                 'mode (form-value "mode")
                 'backup_user (form-value "backup_user")
                 'time (form-value "time"))
      (ui-effect))))

(define (ui-restore-progress jobid)
  (let* ((done (lambda() (form-set-timeout (lambda() (form-update-visibility "restore_message" #f)) 1)))
         (next (lambda() (form-set-timeout (lambda() (ui-restore-progress jobid)) 1)))
	 (data (cond-car (woo "status" "/bacula-local-backup" 'name (form-value "name") 'jobid jobid)))
	 (job_status (string->symbol (woo-get-option data 'job_status))))
    (case job_status
      ((T e)
       (form-update-value "restore_message" (_ "Restore completed"))
       (done))
      ((B E f A)
       (form-update-value "restore_message" (_ "Restore failed, see logs for details")))
      ((C)
       (form-update-value "restore_message" (_ "Starting restore..."))
       (next))
      ((R D F S m M s j c d p a i)
       (form-update-value "restore_message" (format #f "~A ~A ..." (_ "Restoring file") (woo-get-option data 'job_progress)))
       (next)))))

(define (ui-restore)
  (catch/message
    (lambda()
      (let ((result  (cond-car (woo "restore" "/bacula-local-backup"
			  'language (form-value "language")
			  'restore_date (form-value "restore_date")
			  'restore_path (form-value "restore_path")))))
	(form-update-visibility "restore_message" #t)
	(ui-restore-progress (woo-get-option result 'jobid))))))

(define (ui-effect . data)
  (let ((mode (if (pair? data) (woo-get-option (car data) 'mode) (form-value "mode"))))
    (form-update-activity '("backup_user"
			    "disk" "advanced"
			    "restore" "restore_date" "restore_path")
			  (not (string=? mode "off")))))

(define (ui-effect2 . data)
  (let ((mode (if (pair? data) (woo-get-option (car data) 'mode) (form-value "mode"))))
    (form-update-activity "time"
			  (string=? mode "daily"))))

(define (ui-read)
  (catch/message
    (lambda()
      (let ((data (woo-read-first "/bacula-local-backup" 'language (form-value "language"))))
	(form-update-value-list
	  '("mode" "time" "backup_user"
	    "disk_name" "oldest_backup_time" "latest_backup_time"
	    "restore_date" "restore_path")
	  data)
	(ui-effect data)
	(ui-effect2 data)))))

(define (init)
(check_address)
  (ui-read)
  (form-bind "disk" "click" ui-disk)
  (form-bind "mode" "change" ui-effect2)
  (form-bind "advanced" "click" ui-advanced)
  (form-bind "save" "click" ui-save)
  (form-bind "restore" "click" ui-restore))
