(define-module (ui bacula local-backup disk ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :export (init))

(define staddress "")                                                                                             
                                                                                                                  
(define (check_address)                                                                                           
  (let* ((data (woo-read "/bacula-director/" )))                                                                  
  (set! staddress (woo-get-option (car data) 'storage_address)))                                                  
    (if (equal? staddress "" )                                                                                    
    (begin                                                                                                        
    (form-update-visibility "nostatic_page" #t)                                                                   
    (form-update-visibility "static_page" #f))                                                                    
    )) 

(define (ui-cancel)
    (form-replace "/bacula/local-backup"))

(define (ui-change)
  (catch/message
    (lambda()
      (woo-write "/bacula-local-backup/disk"
                 'language (form-value "language")
                 'retention (form-value "retention")
		 'disk (form-value "disk")
		 'disk_uuid (form-value "disk_uuid"))
      (ui-cancel))))

(define (ui-effect . data)
  (let ((disk (if (pair? data) (woo-get-option data 'disk) (form-value "disk"))))
    (form-update-activity "disk_uuid" (string=? disk "user"))))

(define (ui-read)
  (let ((data (woo-read-first "/bacula-local-backup/disk")))
   (form-update-value-list '("system_disk_path" "disk" "disk_uuid" "retention") data)
   (ui-effect data)))

(define (init)
(check_address)
  (form-update-enum "retention" (woo-list "/bacula-local-backup/retention" 'language (form-value "language")))
  (form-update-enum "disk_uuid" (woo-list "/bacula-local-backup/disk" 'language (form-value "language")))
  (ui-read)
  (form-bind "disk" "change" ui-effect)
  (form-bind "cancel" "click" ui-cancel)
  (form-bind "change" "click" ui-change))
