(document:surround "/std/frame")

;;; UI

width 640
height 400

(gridbox
  columns "100"
  margin "10"

  (hbox
    align "left"
    (radio name "disk" value "system" text (_ "Use system disk"))
    (label text " (")
    (label name "system_disk_path")
    (label text ")"))
  (hbox
    align "left"
    (radio name "disk" value "user" text (_ "Use additional disk:"))
    (label text " ")
    (combobox name "disk_uuid"))

  (label)
  (hbox
    align "left"
    (label text (_ "Store backups for:"))
    (label text " ")
    (combobox name "retention"))
  (label)

  (label)
  (label text-wrap #t
         text (string-append (bold (_ "Attention:"))
                             (_ "All existing backups on the new disk will be removed.")))
  (label)

  (hbox
    align "left"
    (button name "cancel" text (_ "Cancel"))
    (label text "   ")
    (button name "change" text (_ "Change disk"))))

;;; functions (like in ajax.scm instead of form-popup)

(define (ui-cancel)
    (document:end))

(define (ui-change)
  (catch/message
    (lambda()
      (woo-write "/bacula-local-backup/disk"
                 'language (form-value "language")
                 'retention (form-value "retention")
		 'disk (form-value "disk")
		 'disk_uuid (form-value "disk_uuid"))
      (document:end))))

(define (ui-effect . data)
  (let ((disk (if (pair? data) (woo-get-option data 'disk) (form-value "disk"))))
    (form-update-activity "disk_uuid" (string=? disk "user"))))

(define (ui-read)
  (let ((data (woo-read-first "/bacula-local-backup/disk")))
   (form-update-value-list '("system_disk_path" "disk" "disk_uuid" "retention") data)
   (ui-effect data)))

(define (init)
  (form-update-enum "retention" (woo-list "/bacula-local-backup/retention"))
  (form-update-enum "disk_uuid" (woo-list "/bacula-local-backup/disk"))
  (ui-read)
  (form-bind "disk" "change" ui-effect)
  (form-bind "cancel" "click" ui-cancel)
  (form-bind "change" "click" ui-change))

(document:root (when loaded (init)))
