(document:surround "/std/frame")

;;; UI

(gridbox
  columns "0;100"
  margin "20"

  (radio colspan "2" text (_ "Don't backup system") name "mode" value "off")
  (hbox
    colspan "2"
    align "left"
    (radio colspan "2" text (_ "Backup system every day at:") name "mode" value "daily")
    (label text " ")
    (edit name "time"))

  (label colspan "2")

  (label align "right" text (_ "Backup disk:"))
  (label name "disk_name")
  (label align "right" text (_ "Oldest backup:"))
  (label name "oldest_backup_time")
  (label align "right" text (_ "Latest backup:"))
  (label name "latest_backup_time")

  (label colspan "2")
  (hbox
    colspan "2"
    align "left"
    (button name "save" text (_ "Save settings"))
    (label text "  ")
    (button name "disk" text (_ "Change disk..."))
    (label text " ")
    (button name "advanced" text (_ "Advanced...")))

  (separator colspan "2")
  (label colspan "2")

  (gridbox
    columns "0;100"
    colspan "2"
    align "left"

    (label align "right" name "restore_path" text (_ "Restore file or directory:"))
    (edit name "restore_path")

    (label align "right" text (_ "Date:") name "restore_date")
    (dateedit name "restore_date" align "left"))

  (label colspan "2")

  (button colspan "2" align "left" name "restore" text (_ "Restore")))

;;; functions (like in ajax.scm instead of form-popup)

(define (ui-advanced)
  (form-popup "/bacula/local-backup/advanced")
  (ui-read))

(define (ui-disk)
  (form-popup "/bacula/local-backup/disk")
  (ui-read))

(define (ui-save)
  (catch/message
    (lambda()
      (woo-write "/bacula-local-backup"
                 'language (form-value "language")
                 'mode (form-value "mode")
                 'backup_user (form-value "backup_user")
                 'time (form-value "time"))
      (ui-effect))))

(define (ui-restore)
  (catch/message
    (lambda()
      (woo "restore" "/bacula-local-backup"
           'language (form-value "language")
           'restore_date (form-value "restore_date")
           'restore_path (form-value "restore_path")))))

(define (ui-effect . data)
  (let ((mode (if (pair? data) (woo-get-option (car data) 'mode) (form-value "mode"))))
    (form-update-activity '("backup_user"
			    "disk" "advanced"
			    "restore" "restore_date" "restore_path")
			  (not (string=? mode "off")))))

(define (ui-effect2 . data)
  (let ((mode (if (pair? data) (woo-get-option (car data) 'mode) (form-value "mode"))))
    (form-update-activity "time"
			  (string=? mode "daily"))))

(define (ui-read)
  (catch/message
    (lambda()
      (let ((data (woo-read-first "/bacula-local-backup" 'language (form-value "language"))))
	(form-update-value-list
	  '("mode" "time" "backup_user"
	    "disk_name" "oldest_backup_time" "latest_backup_time"
	    "restore_date" "restore_path")
	  data)
	(ui-effect data)
	(ui-effect2 data)))))

(define (init)
  (ui-read)
  (form-bind "disk" "click" ui-disk)
  (form-bind "mode" "change" ui-effect2)
  (form-bind "advanced" "click" ui-advanced)
  (form-bind "save" "click" ui-save)
  (form-bind "restore" "click" ui-restore))

(document:root (when loaded (init)))
