(document:surround "/std/frame")

;;; UI

;; flag to avoid second start on frame:next
(define *ui-restore* (make-cell #f))

(gridbox
  columns "100"
  margin 50
  name "progress"
  visibility #f
  (label name "stage")
  (label name "status" text-wrap #t))

(gridbox
  columns "100"
  margin 50
  name "select"
  visibility #t
  (label text (_ "Select backup date:"))
  (listbox name "date"))

;;; logic

(define (ui-stop)
  (remove-mailbox ui-callback))

(define (ui-done)
  (ui-stop)
  (frame:next))

(define (ui-fatal-error reason)
  (ui-stop)
  (form-update-value "stage"
		     (bold (_ "Fatal error")))
  (form-update-value "status"
		     reason))

(define (ui-restore-error)
  (ui-stop)
  (frame:next-activity #t)
  (form-update-value "stage"
		     (bold (_ "Error during restore process")))
  (form-update-value "status" (_ "However you can try to continue")))

(define (ui-restore)
  (or (cell-ref *ui-restore*)
      (catch/message
	(lambda()
	  (cell-set! *ui-restore* #t)
	  (frame:next-activity #f)
	  (form-update-visibility "select" #f)
	  (form-update-visibility "progress" #t)
	  (add-mailbox ui-callback)
	  (woo "restore" "/bacula-restore" 'date (form-value "date"))
	  (form-update-value "stage" "")
	  (form-update-value "status" "")
	  'cancel))))

(define (ui-stage stage)
  (form-update-value "status" "")
  (form-update-value "stage"
		     (bold
		       (case stage
			 ((prepare) (_ "Running restore process..."))
			 ((restore-system) (_ "Restoring system..."))
			 ((done) (_ "Restoring is done"))))))

(define (ui-callback args)
  (case (car args)
    ((stage)
     (let ((stage (string->symbol (cadr args))))
       (ui-stage stage)
       (and (eq? stage 'done) (ui-done))))
    ((restore-error)
     (ui-restore-error))
    ((fatal-error)
     (ui-fatal-error (cadr args)))
    ((status)
     (form-update-value "status" (cadr args)))))

(define (ui-init)
  (frame:back-activity #f)
  (catch/message
    (lambda()
      (let* ((date-list (woo-list "/bacula-restore/date"))
	     (date-first (cond-car date-list)))
	(form-update-enum "date" date-list)
	(if date-first
	  (form-update-value "date" (woo-get-option date-first 'name))
	  (woo-error "No backups available"))))))

(frame:on-next ui-restore)

(document:root (when loaded (ui-init)))
