(document:surround "/std/frame")

;;; UI

(gridbox
  columns "100"
  margin 50
  (label name "stage")
  (label name "status" text-wrap #t)
  (button text (_ "Continue") align "left" name "continue_button"))

;;; logic

(define (ui-stop)
  (remove-mailbox ui-callback))

(define (ui-done)
  (catch/message
    (lambda()
	(ui-stop)
	(woo "wait" "/bacula-restore")
        (frame:replace "/bacula/restore/restore"))))

(define (ui-fatal-error reason)
  (ui-stop)
  (form-update-value "stage"
		     (bold (_ "Fatal error")))
  (form-update-value "status"
		     reason))

(define (ui-again)
  (form-update-visibility '("continue_button") #t)
  (form-update-value "status"
		     (_ "Unable to find backup disk. Please insert one and try again...")))

(define (ui-search)
  (catch/message
    (lambda()
     (woo "search" "/bacula-restore")
     (form-update-value "stage" "")
     (form-update-value "status" "")
     (form-update-visibility '("continue_button") #f))))

(define (ui-stage stage)
  (form-update-value "status" "")
  (form-update-value "stage"
		     (bold
		       (case stage
			 ((search) (_ "Searching for backups..."))
			 ((prepare) (_ "Preparing..."))
			 ((restore-db) (_ "Restoring backup database..."))
			 (else "")))))

(define (ui-callback args)
  (case (car args)
    ((stage)
     (let ((stage (string->symbol (cadr args))))
       (ui-stage stage)
       (and (eq? stage 'done) (ui-done))))
    ((search-error)
     (ui-again))
    ((fatal-error)
       (ui-fatal-error (cadr args)))
    ((status)
     (form-update-value "status" (cadr args)))))

(document:root
  (when loaded
    (frame:next-activity #f)
    (frame:back-activity #f)
    (add-mailbox ui-callback)
    (form-bind "continue_button" "click" ui-search)
    (ui-search)))
