(define-module (ui bind ajax)
    :use-module (alterator ajax)
    :use-module (alterator effect)
    :use-module (alterator woo)
    :export (init))

(define (ui-host-list)
  (form-update-enum
    "ddns_host"
    (woo-list "/bind/ddns_host" 'ddns_domain (form-value "ddns_domain"))))


(define (ui-host-add)
  (catch/message
    (lambda()
      (let ((new_ddns_ip (form-value "new_ddns_ip"))
	    (new_ddns_host (form-value "new_ddns_host")))
	(and (string? new_ddns_ip)
	     (string? new_ddns_host)
	     (begin
	       (woo "add" "/bind"
		    'language (form-value "language")
		    'ddns_domain (form-value "ddns_domain")
		    'new_ddns_ip (form-value "new_ddns_ip")
		    'new_ddns_host (form-value "new_ddns_host"))
	       (form-update-value "new_ddns_ip" "")
	       (form-update-value "new_ddns_host" "")
	       (ui-host-list)))))))

(define (ui-host-del)
  (catch/message
    (lambda()
      (let ((ddns_host (form-value "ddns_host")))
        (and (string? ddns_host)
             (begin
               (woo "del" "/bind"
                    'language (form-value "language")
                    'ddns_domain (form-value "ddns_domain")
                    'ddns_host ddns_host)
               (ui-host-list)))))))

(define *parameter-list* '("ddns_type" "ddns_has_key" "ddns_master" "ddns_ns" "ddns_mx" "ddns_network"))

(define (ui-write)
  (catch/message
    (lambda()
      (apply woo-write "/bind"
			'language (form-value "language")
			'ddns_domain (form-value "ddns_domain")
			(form-value-list *parameter-list*))
      (ui-read))))

(define (ui-read)
  (form-update-value-list
    *parameter-list*
    (woo-read-first "/bind" 'ddns_domain (form-value "ddns_domain")))
  (form-update-value "ddns_key_state"
     (if (string= (form-value "ddns_has_key") "0")
       (_ "not loaded yet!")
       (_ "activated")))
  (update-effect)
  (ui-host-list))

(define (ui-list . name)
  (let* ((data (woo-list "/bind/ddns_domain"))
	 (ddns_domain (or (and (pair? name) (car name))
	                  (and (pair? data) (woo-get-option (car data) 'name)))))
    (form-update-enum "ddns_domain" data)
    (cond
      ((string? ddns_domain)
       (form-update-value "ddns_domain" ddns_domain)
       (ui-read)))))

(define (ui-create)
  (catch/message
    (lambda()
      (let ((new_ddns_domain (form-value "new_ddns_domain")))
        (woo "create" "/bind"
             'language (form-value "language")
             'new_ddns_type (form-value "new_ddns_type")
             'new_ddns_domain new_ddns_domain)
        (form-update-value "new_ddns_domain" "")
        (ui-list new_ddns_domain)))))

(define (ui-destroy)
  (catch/message
    (lambda()
      (let ((ddns_domain (form-value "ddns_domain")))
	(cond ((and (string? ddns_domain)
		    (form-confirm (string-append (_ "Are you really want to destroy domain ")
						 (form-value "ddns_domain")
						 "?")))
	       (woo "destroy" "/bind"
		    'language (form-value "language")
		    'ddns_domain ddns_domain)
	       (ui-list)))))))

(define (ui-download)
  (form-replace "/bind/key" 'ddns_domain (form-value "ddns_domain")))

(define (ui-upload)
  (call-with-form-file
	"ddns_key"
	(lambda(path)
	  (catch/message
		(lambda()
		   (woo "write_key" "/bind" 'ddns_key_file path 'ddns_domain (form-value "ddns_domain") 'language (form-value "language"))
		   (ui-read))))))

(define (init)

    (form-update-enum "new_ddns_type" (woo-list "/bind/ddns_type" 'language (form-value "language")))
    (form-update-enum "ddns_network" (woo-list "/bind/ddns_network" 'language (form-value "language")))
    (ui-list)

    (effect-show "ddns_master_field" "ddns_type" "master")
    (effect-show "ddns_slave_field"  "ddns_type" "slave")
    (init-effect)

    (form-bind "ddns_domain" "change" ui-read)

    (form-bind "ddns_download_button" "click" ui-download)
    (form-bind-upload "ddns_upload_button" "click" "ddns_key" ui-upload)

    (form-bind "ddns_apply_button" "click" ui-write)
    (form-bind "ddns_reset_button" "click" ui-read)

    (form-bind "ddns_create_button" "click" ui-create)
    (form-bind "ddns_destroy_button" "click" ui-destroy)

    (form-bind "ddns_add_button" "click" ui-host-add)
    (form-bind "ddns_del_button" "click" ui-host-del))
