(define-module (ui chainmail firsttime ajax)
	:use-module (alterator ajax)
	:use-module (alterator effect)
	:use-module (alterator woo)
	:use-module (alterator str)
	:use-module (srfi srfi-13)

        :use-module ((ui root ajax) :renamer (symbol-prefix-proc 'root:))
	:export (init))

;;; iptables

(define (read-iptables)
  (form-update-enum "external_ifaces" (woo-list "/net-iptables/ifaces")))

(define (commit-iptables)
  (woo "firsttime"
       "/net-iptables"
       'external_ifaces (or (form-value "external_ifaces") "")))

;;; domain
(define (read-domain)
  (form-update-value-list '("domain" "server_role") (woo-read-first "/net-domain")))

(define (commit-domain)
  (let ((domain (form-value "domain"))
	(server_role (form-value "server_role")))
    (or (not-empty-string? server_role)
	(woo-error (_ "Please select server role")))
    (or (not-empty-string? domain)
	(woo-error (_ "Please define domain name")))
    (woo-write "/net-domain"
	       'server_role server_role
	       'domain domain
	       'language (form-value "language")
	       'runhooks #t)))

;;; locale
(define (update-locale)
  (form-update-cookie "language" (form-value "locale"))
  (form-replace "/office-server/firsttime"))

(define (read-locale)
  (catch/message
    (lambda()
      (form-update-enum "locale" (woo-call "/login/list_locale"))
      (form-update-value "locale" (car (string-cut (form-value "language") #\;))))))

;;; common

(define (commit)
  (catch/message
    (lambda()
      (root:commit-passwordbox)
      (commit-iptables)
      (commit-domain)
      (form-replace "/firsttime/finish"))))

(define (init)
    (read-locale)
    (read-domain)
    (root:init-passwordbox)
    (read-iptables)
    (init-effect)
    (form-bind "locale" "change" update-locale)
    (form-bind "apply" "click" commit))
