(define-module (ui hotstandby ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :use-module (alterator effect)
    :use-module (alterator menu)
    :export (init))

(define (read-config)
  (catch/message
    (lambda()
      (let ((config (woo-read-first "/hotstandby"
                                    'language (form-value "language"))))
        (form-update-value-list '("node_role" "failback" "keepalive" "initdead" "deadtime" "res_iface" "res_ip"
                                  "res_netmask" "com_iface" "other_node_hostname" "other_node_ip")
                                config))))
  (update-effect))

(define (ui-init)
  (let ((ifaces (woo-list "/hotstandby/avail_ifaces")))
    (form-update-enum "res_iface" ifaces)
    (form-update-enum "com_iface" ifaces)
    (form-update-enum "res_netmask" (woo-list "/hotstandby/avail_netmasks"))))

(define (write-config)
  (catch/message
    (lambda()
      (apply woo-write "/hotstandby"
                 (form-value-list
                   '("node_role" "failback" "keepalive" "initdead" "deadtime" "res_iface" "res_ip" 
                     "res_netmask" "com_iface" "other_node_hostname" "other_node_ip" "language")))))
  (read-config)
  (menu-reset-item)
  (form-replace "/hotstandby"))

(define (read-confbundle)
  (form-replace "/hotstandby/confbundle"))

(define (write-confbundle)
  (call-with-form-file
    "confbundle"
    (lambda(path)
      (catch/message
        (lambda()
          (woo-write "/hotstandby/confbundle"
                     'confbundle path
                     'language (form-value "language"))))))
  (read-config))

(define (init)
  (ui-init)
  (effect-enable "failback" "node_role" "main")
  (effect-enable "keepalive" "node_role" "main")
  (effect-enable "initdead" "node_role" "main")
  (effect-enable "deadtime" "node_role" "main")
  (effect-enable "res_iface" "node_role" "main")
  (effect-enable "res_ip" "node_role" "main")
  (effect-enable "res_netmask" "node_role" "main")
  (effect-enable "com_iface" "node_role" "main")
  (effect-enable "other_node_hostname" "node_role" "main")
  (effect-enable "other_node_ip" "node_role" "main")
  (effect-show "download_label" "node_role" "main")
  (effect-show "download_button" "node_role" "main")
  (effect-hide "upload_label" "node_role" "main")
  (effect-hide "confbundle" "node_role" "main")
  (effect-hide "upload_button" "node_role" "main")
  (effect-hide "main_node_label" "node_role" "main")
  (effect-show "reserve_node_label" "node_role" "main")
  (init-effect)
  (read-config)
  (form-bind "download_button" "click" read-confbundle)
  (form-bind-upload "upload_button" "click" "confbundle" write-confbundle)
  (form-bind "apply" "click" write-config))
