(define-module (ui ldap-groups ajax)
    :use-module (alterator woo)
    :use-module (alterator ajax)
    :use-module (alterator str)
    :use-module (srfi srfi-1)
    :use-module (srfi srfi-11)
    :use-module (srfi srfi-2)
    :use-module (alterator effect)
    :use-module (alterator plist)
    :export (init))
;;;

(define *rootdn* "")
(define *rootpw* "")
(define *bind_info* "present")
(define *host* "localhost")
(define *ldapbase* "")
(define *mode* "local")

;;; members
(define (update-member-list . data)
    (let ((group (if (pair? data) (car data) (form-value "group"))))
      (form-update-enum "member_in" (woo "member_list_in" "/ldap-groups" 'group group))
      (form-update-enum "member_out" (woo "member_list_out" "/ldap-groups" 'group group))))

(define (ui-member-add)
  (let ((group (form-value "group"))
        (member_out (form-value "member_out")))
    (and (string? group) (string? member_out)
	 (catch/message
	   (lambda()
	     (woo "member_add"
	      "/ldap-groups"
		  'language (form-value "language")
		  'group group
		  'member_out member_out)
	     (update-member-list (form-value "group")))))))

(define (ui-member-del)
  (let ((group (form-value "group"))
        (member_in (form-value "member_in")))
    (and (string? group) (string? member_in)
	 (catch/message
	   (lambda()
	     (woo "member_del"
	       "/ldap-groups"
		  'language (form-value "language")
		  'group group
		  'member_in member_in)
	     (update-member-list (form-value "group")))))))

;;; emails
(define (update-email-list . data)
    (let ((group (if (pair? data) (car data) (form-value "group"))))
      (form-update-enum "email" (woo "email_list" "/ldap-groups" 'group group))))

(define (ui-email-add)
  (let ((group (form-value "group"))
        (new_email (form-value "new_email")))
    (and (string? group) (string? new_email)
	 (catch/message
	   (lambda()
	     (woo "email_add"
	      "/ldap-groups"
		  'language (form-value "language")
		  'group group
		  'new_email new_email)
	     (form-update-value "new_email" "")
	     (update-email-list (form-value "group")))))))

(define (ui-email-del)
  (let ((group (form-value "group"))
        (email (form-value "email")))
    (and (string? group) (string? email)
	 (catch/message
	   (lambda()
	     (woo "email_del"
	      "/ldap-groups"
		  'language (form-value "language")
		  'group group
		  'email email)
	     (update-email-list (form-value "group")))))))

;;; groups
(define (update-groups . data)
  (let ((group (if (pair? data) (car data) (form-value "group"))))
    (if (not (string-contains group ";"))
      (begin
        (form-update-visibility "update_message" #f)
	(form-update-value "group_name" group)
	(woo "member_reset" "/ldap-groups" 'group group)
	(woo "email_reset" "/ldap-groups" 'group group)
	(update-member-list group)
	(if (equal? *mode* "ldap")
	    (update-email-list group))))))

(define (ui-group-del)
  (let ((group (form-value "group")))
    (and (string? group)
	 (catch/message
	   (lambda()
	     (woo-delete "/ldap-groups" 'group group 'language (form-value "language"))
	     (ui-init))))))

(define (ui-group-add)
  (let ((new_group (form-value "new_group")))
    (and (string? new_group)
	 (catch/message
	   (lambda()
	     (woo-new "/ldap-groups" 'new_group new_group 'language (form-value "language"))
	     (ui-init)
	     (form-update-value "group" new_group)
	     (update-groups new_group))))))

(define (ui-group-save)
  (let ((group (form-value "group")))
    (and (string? group)
	 (catch/message
	   (lambda()
	     (form-update-visibility "update_message" #f)
	     (woo "member_commit"
	      "/ldap-groups" 'language (form-value "language") 'group group)
	    (if (equal? *mode* "ldap")
	     (woo "email_commit" "/ldap-groups" 'language (form-value "language") 'group group))
	    (update-groups group)
	    (form-update-visibility "update_message" #t))))))

(define (local_s)
    (form-update-visibility "local_src" #t)
    (form-update-visibility "ldap_src" #f)
    (form-update-visibility "mail_h" #f)
    (form-update-visibility "mail_div" #f)
    (form-update-visibility "smb_button" #f))

(define (ldap_s)
    (form-update-visibility "local_src" #f)
    (form-update-visibility "ldap_src" #t)
    (form-update-visibility "mail_h" #t)
    (form-update-visibility "smb_button" #t))

(define (select_other)
    (form-update-visibility "need_bind_info" #f)
    (form-update-visibility "main_area" #f)
    (form-update-visibility "addgrp_area" #f)
    (form-update-visibility "info_area" #f)
    (form-update-visibility "select_area" #t)
)

(define (return_to_list)
    (form-update-visibility "need_bind_info" #f)
    (form-update-visibility "main_area" #t)
    (form-update-visibility "addgrp_area" #t)
    (form-update-visibility "info_area" #t)
    (form-update-visibility "select_area" #f)
)

(define (other_selected)
    (catch/message
      (lambda()
        (woo-new "/ldap-groups/source"
            'newmode (form-value "use_src")
            'new_base (form-value "new_base_src")
            'host (form-value "rem_host")
            'new_base (form-value "new_base_src")
            'new_rem_base (form-value "rem_base_src")
            'language (form-value "language"))
         ))
      (ui-init)
)

(define (bind_info)
    (set! *rootpw* "")
    (form-update-value "bind_rootpw" *rootpw*)
    (form-update-visibility "need_bind_info" #t)
    (form-update-visibility "main_area" #f)
    (form-update-visibility "addgrp_area" #f)
    (form-update-visibility "info_area" #f)
    (form-update-visibility "select_area" #f)
)

(define (main_mode)
    (form-update-visibility "need_bind_info" #f)
    (form-update-visibility "select_area" #f)
    (form-update-visibility "main_area" #t)
    (form-update-visibility "addgrp_area" #t)
)

(define (check_mode)
    (let* ((data (woo-list "/ldap-groups/mode" )))
            (set! *bind_info* (woo-get-option (car data) 'bind_info))
            (set! *rootdn* (woo-get-option (car data) 'rootdn))
            (set! *rootpw* (woo-get-option (car data) 'rootpw))
            (set! *mode* (woo-get-option (car data) 'mode))
            (set! *ldapbase* (woo-get-option (car data) 'base))
            (set! *host* (woo-get-option (car data) 'host)))
    (cond
            ((string-ci=? *mode* "local")(local_s))
            ((string-ci=? *mode* "ldap")(ldap_s))
            (else (local_s)))

    (form-update-value "base_" *ldapbase*)
    (form-update-value "host_" *host*)
    (if (equal? *host* "localhost")
      (begin
        (form-update-value "bind_rootdn" *rootdn*))
      (begin
        (form-update-value "bind_rootdn" "")))
    (bind_request))

(define (bind_request)
    (if (equal? *bind_info* "present")
      (begin
        (main_mode))
      (begin
        (bind_info))))

(define (set_src)
     (let ( (src (car (string-cut-repeated (or (form-value "use_src") "local") #\,))) )
      (cond
       ((string-ci=? src "local")(set_local_src))
       ((string-ci=? src "ldap")(set_ldap_src))
       ((string-ci=? src "localldap")(set_localldap_src))
       (else (set_local_src)))))

(define (set_local_src)
    (form-update-visibility "new_base_src" #f)
    (form-update-visibility "rem_base_src_div" #f))

(define (set_ldap_src)
    (form-update-visibility "new_base_src" #f)
    (form-update-visibility "rem_base_src_div" #t))

(define (set_localldap_src)
    (form-update-enum "new_base_src" 
	(woo-list "/ldap-groups/bases" 
	    'language (form-value "language")))
    (form-update-visibility "new_base_src" #t)
    (form-update-visibility "rem_base_src_div" #f))

(define (read_rem_bases)
    (form-update-enum "rem_base_src"
    (woo-list "/ldap-users/bases" 'rem_host (form-value "rem_host")
            'language (form-value "language"))))

(define (set_bind)
    (if (not (string-null? (form-value "bind_rootpw")))
       (begin
        (set! *rootpw* (form-value "bind_rootpw"))
        (set! *rootdn* (form-value "bind_rootdn"))
        (set! *bind_info* "present")))
        (woo "set_bind" "/ldap-groups"
            'mode "ldap"
            'base *ldapbase*
            'host *host*
            'rootpw *rootpw*
            'rootdn *rootdn*
            'bind_info *bind_info*
            'language (form-value "language") )
    (bind_request))

(define (ui-init)
    (check_mode)
    (form-update-value "new_group" "")
    (form-update-value "group_name" "")
    (form-update-enum "member_in" '())
    (form-update-enum "member_out" '())
    (form-update-value "new_email" "")
    (form-update-visibility "update_message" #f)
    (form-update-visibility "info_area" #t)
    (form-update-enum "group" 
	(woo-list "/ldap-groups/" 
		    'language (form-value "language")))
    
)

(define (init)
    (ui-init)
    (form-bind "group" "change" update-groups)
    (form-bind "use_src" "change" set_src)
    (form-bind "rem_host" "change" read_rem_bases)
    (form-bind "member_add_button" "click" ui-member-add)
    (form-bind "member_del_button" "click" ui-member-del)
    (form-bind "email_add_button" "click" ui-email-add)
    (form-bind "email_del_button" "click" ui-email-del)
    (form-bind "group_save_button" "click" ui-group-save)
    (form-bind "group_del_button" "click" ui-group-del)
    (form-bind "group_add_button" "click" ui-group-add)
    (form-bind "select_btn" "click" select_other)
    (form-bind "useit_btn" "click" other_selected)
    (form-bind "ret_list" "click" return_to_list)
    (form-bind "bind_btn" "click" set_bind))
