(define-module (ui ldap-users ajax)
    :use-module (alterator woo)
    :use-module (alterator ajax)
    :use-module (alterator str)
    :use-module (alterator effect)
    :export (init))

(define *rootdn* "")
(define *rootpw* "")
(define *bind_info* "present")
(define *host* "localhost")
(define *ldapbase* "")
(define *mode* "local")

(define *user-parameter-list*
  '("sn" "givenname" "patronym" "homedirectory" "loginshell"
    "o" "ou" "title" "telephonenumber" "mobile" "user" "jpegphoto" "uidNumber"
    "departmentnumber" "postaladdress"))

(define *passwd-parameter-list*
  '("auto" "passwd_1" "passwd_2" "passwd_auto"))

(define (update-users . data)
  (let ((user (if (pair? data) (car data) (form-value "user"))))
    (if (not (string-contains user ";"))
      (begin
        (form-update-visibility "update_message" #f)
        (form-update-visibility "data_not_saved" #f)
        (ui-reset-password)
        (form-update-value "username" user)
	(form-update-enum "departmentnumber_list" (woo-list "/ldap-users/departmentnumber_list"))
	(form-update-enum "title_list" (woo-list "/ldap-users/title_list"))
	(form-update-value-list
	  *user-parameter-list*
	  (woo-read-first "/ldap-users" 'user user))
	(update-group-in-list user)
	(update-group-out-list user)
	(update-mail-list user)))))


(define (update-group-in-list . data)
  (let ((user (if (pair? data) (car data) (form-value "user"))))
    (form-update-enum "in_groups" (woo-list "/ldap-users/member_of" 'user user))))

(define (update-group-out-list . data)
  (let ((user (if (pair? data) (car data) (form-value "user"))))
    (form-update-enum "out_groups" (woo-list "/ldap-users/member_out" 'user user))))

(define (set_filter)
     (let ( (type (car (string-cut-repeated (or (form-value "use_filter") "real") #\,))) )
      (cond
       ((string-ci=? type "system")(set_system_filter))
       ((string-ci=? type "real")(set_real_filter))
       (else (set_real_filter))))
)

(define (set_system_filter)
    (form-update-value "min_uid" "0")
    (form-update-value "max_uid" "499")
    (filtered_userlist)
)

(define (set_real_filter)
    (form-update-value "min_uid" "499")
    (form-update-value "max_uid" "9000")
    (filtered_userlist)
)

(define (filtered_userlist)
  (catch/message
	    (lambda() (form-update-enum "user"
	       (woo-list "/ldap-users/userlist"
	       'minuid (form-value "min_uid")
	       'maxuid (form-value "max_uid")
	       'language (form-value "language")))))
  (form-update-visibility "userdelete" #f)
  (form-update-visibility "info_frame" #f)
  (form-update-visibility "usersave" #f)
  (form-update-visibility "update_message" #f)
)

(define (check_mode)
  (let* ((data (woo-list "/ldap-users/mode" )))
	    (set! *bind_info* (woo-get-option (car data) 'bind_info))
	    (set! *rootdn* (woo-get-option (car data) 'rootdn))
	    (set! *rootpw* (woo-get-option (car data) 'rootpw))
	    (set! *mode* (woo-get-option (car data) 'mode))
	    (set! *ldapbase* (woo-get-option (car data) 'base))
	    (set! *host* (woo-get-option (car data) 'host)))
	    (form-update-value "bind_rootdn" *rootdn*)
	    (form-update-value "base_" *ldapbase*)
	    (form-update-value "host_" *host*)
    (if (equal? *mode* "local")
      (begin
	(form-update-visibility "photo_frame" #f)
	(form-update-visibility "work_h" #f)
	(form-update-visibility "mail_h" #f))
      (begin
	(form-update-visibility "photo_frame" #t)
	(form-update-visibility "work_h" #t)
	(form-update-visibility "mail_h" #t)))
)

(define (bind_info)
    (set! *rootpw* "")
    (form-update-value "bind_rootpw" *rootpw*)
    (form-update-visibility "need_bind_info" #t)
    (form-update-visibility "main_area" #f)
    (form-update-visibility "adduser_area" #f)
    (form-update-visibility "select_area" #f)
)

(define (main_mode)
    (form-update-visibility "need_bind_info" #f)
    (form-update-visibility "select_area" #f)
    (form-update-visibility "main_area" #t)
    (form-update-visibility "nav_buttons" #t)
    (form-update-visibility "account_row" #t)
    (form-update-visibility "group_row" #f)
    (form-update-visibility "adduser_area" #t)
)

(define (ui-init . data)
  (check_mode)
  (for-each
    (lambda(x) (form-update-value x ""))
    (append '("newusername" "username") *user-parameter-list*))
  (ui-reset-password)
  (filtered_userlist)
  (form-update-enum "departmentnumber_list" (woo-list "/ldap-users/departmentnumber_list"))
  (form-update-enum "title_list" (woo-list "/ldap-users/title_list"))
  (form-update-enum "loginshell" (woo-list "/ldap-users/avail_shell"))
  (form-update-visibility "update_message" #f)
  (form-update-visibility "data_not_saved" #f)
  (form-update-enum "email" '() )
  (form-update-enum "in_groups" '() )
  (form-update-enum "out_groups" '() ))

(define (ui-usersave)
  (let ((user (form-value "user")))
    (if (string? user)
      (catch/message
	(lambda()
	  (form-update-visibility "update_message" #f)
	  (apply woo-write "/ldap-users" 'user (form-value "user") 'language (form-value "language")
		 'departmentnumber_list (form-value "departmentnumber_list") 'title_list (form-value "title_list")
		 (form-value-list (append *passwd-parameter-list* *user-parameter-list*)))
	  (woo "email_commit" "/ldap-users" 'user user 'language (form-value "language"))
	  (update-users user)
	  (saved)
	  )))))

(define (ui-userdel)
  (let ((user (form-value "user")))
    (if (string? user)
      (catch/message
	(lambda()
	  (woo-delete "/ldap-users/user" 'user user 'language (form-value "language"))
	  (ui-init))))))

(define (ui-useradd)
  (let ((newusername (form-value "newusername")))
    (catch/message
      (lambda()
	(woo-new "/ldap-users/user" 'newusername newusername 'language (form-value "language"))
	(filtered_userlist)
	(form-update-value "user" newusername)
	(form-update-value "newusername" "")
	(update-users newusername)))))

(define (ui-emailadd)
  (catch/message
    (lambda()
      (let ((user (form-value "user"))
	    (newemail (form-value "newemail")))
	(cond ((and (string? user) (string? newemail))
	       (woo "email_add" "/ldap-users" 'user user 'newemail newemail 'language (form-value "language"))
	       (update-mail-list)))))))

(define (ui-emaildel)
  (catch/message
    (lambda()
      (let ((user (form-value "user"))
	    (email (form-value "email")))
	(cond ((and (string? user) (string? email))
	       (woo "email_del" "/ldap-users" 'user user 'email email 'language (form-value "language"))
	       (update-mail-list)))))))

(define (update-mail-list . data)
  (let ((user (if (pair? data) (car data) (form-value "user"))))
    (form-update-value "newemail" "")
    (form-update-enum "email" (woo "email_list" "/ldap-users" 'user user ))))

(define (ui-generate)
  (form-update-value-list
    '("passwd_auto")
    (car (woo "generate" "/ldap-users"))))

(define (ui-reset-password)
  (form-update-value "passwd_1" "")
  (form-update-value "passwd_2" "")
  (form-update-value "auto" #f)
  (ui-generate)
  (update-effect))

(define (ui-add-to-group)
  (let ((newgrp (form-value "out_groups"))
	(user (form-value "user")))
    (if (string? newgrp)
      (catch/message
	(lambda()
	  (woo-write "/ldap-users/newgroup"
	    'user user 'newgrp newgrp
	    'language (form-value "language"))
	  )))
    (update-group-in-list user)
    (update-group-out-list user))
    (not_saved)
)

(define (ui-del-from-group)
  (let ((delgrp (form-value "in_groups"))
	(user (form-value "user")))
    (if (string? delgrp)
      (catch/message
	(lambda()
	  (woo-write "/ldap-users/delgroup"
	    'user user 'delgrp delgrp
	    'language (form-value "language"))
	  )))
    (update-group-in-list user)
    (update-group-out-list user))
    (not_saved)
)

(define (on-migrate)
  (form-replace "/ldap-users/migration"))

(define (select_other)
    (form-update-visibility "need_bind_info" #f)
    (form-update-visibility "main_area" #f)
    (form-update-visibility "adduser_area" #f)
    (form-update-visibility "select_area" #t)
)

(define (other_selected)
    (catch/message
      (lambda()
	(woo-new "/ldap-users/source"
	    'newmode (form-value "use_src")
	    'new_base (form-value "new_base_src")
	    'host (form-value "rem_host")
	    'new_base (form-value "new_base_src")
	    'new_rem_base (form-value "rem_base_src")
	    'language (form-value "language"))
	 ))
    (ui-init)
    (bind_request)
)

(define (set_src)
     (let ( (src (car (string-cut-repeated (or (form-value "use_src") "local") #\,))) )
      (cond
       ((string-ci=? src "local")(set_local_src))
       ((string-ci=? src "ldap")(set_ldap_src))
       ((string-ci=? src "localldap")(set_localldap_src))
       (else (set_local_src))))
)

(define (set_local_src)
    (form-update-visibility "new_base_src" #f)
    (form-update-visibility "rem_base_src_div" #f)
)

(define (set_ldap_src)
    (form-update-visibility "new_base_src" #f)
    (form-update-visibility "rem_base_src_div" #t)
)

(define (set_localldap_src)
    (form-update-enum "new_base_src" (woo-list "/ldap-users/bases" 'language (form-value "language")))
    (form-update-visibility "new_base_src" #t)
    (form-update-visibility "rem_base_src_div" #f)
)

(define (read_rem_bases)
    (form-update-enum "rem_base_src"
    (woo-list "/ldap-users/bases" 'rem_host (form-value "rem_host")
	    'language (form-value "language")))
)

(define (return_to_list)
    (form-update-visibility "need_bind_info" #f)
    (form-update-visibility "select_area" #f)
    (form-update-visibility "main_area" #t)
    (form-update-visibility "adduser_area" #t)
)

(define (show-upload)
    (form-update-visibility "photo_upload_area" #t)
)
(define (hide-upload)
    (form-update-visibility "photo_upload_area" #f)
)
(define (on-upload)
   (call-with-form-file "photo_file"
	(lambda(path)
	  (catch/message
	    (lambda()
	       (woo-new "/ldap-users/user_photo"
	       'photo_file path
	       'user (form-value "user")
		))))
   )
    (form-update-visibility "photo_upload_area" #f)
    (update-users)
)

(define (photo_del)
   (let ((user (form-value "user")))
    (if (string? user)
      (catch/message
	(lambda()
	  (woo "delete" "/ldap-users/photo" 'user user 'language (form-value "language"))
	  (update-users))))))

(define (set_bind)
    (if (not (string-null? (form-value "bind_rootpw")))
       (begin
	(set! *rootpw* (form-value "bind_rootpw"))
	(set! *rootdn* (form-value "bind_rootdn"))
	(set! *bind_info* "present")))
	(woo "set_bind" "/ldap-users" 
	    'mode "ldap" 
	    'base *ldapbase*
	    'host *host*
	    'rootpw *rootpw*
	    'rootdn *rootdn*
	    'bind_info *bind_info*
	    'language (form-value "language") )
	
    (bind_request)
)

(define (bind_request)
    (if (equal? *bind_info* "present")
      (begin
	(main_mode))
      (begin
	(bind_info)
	))
)

(define (not_saved)
    (form-update-visibility "update_message" #f)
    (form-update-visibility "data_not_saved" #t)
)

(define (saved)
    (form-update-visibility "update_message" #t)
    (form-update-visibility "data_not_saved" #f)
)

;;;
(define (init)
    (ui-init)

    (effect-hide "userdelete" "user" "")
    (effect-hide "usersave" "user" "")
    (effect-show "passwd_1" "auto" #f)
    (effect-show "passwd_2" "auto" #f)
    (effect-show "passwd_auto" "auto" #t)
    (effect-show "generate_button" "auto" #t)
    (effect-hide "info_frame" "user" "")
    (init-effect)

    (form-bind "use_filter" "change" set_filter)
    (form-bind "use_src" "change" set_src)
    (form-bind "generate_button" "click" ui-generate)
    (form-bind "emailadd" "click" ui-emailadd)
    (form-bind "emaildel" "click" ui-emaildel)
    (form-bind "usersave" "click" ui-usersave)
    (form-bind "useradd" "click" ui-useradd)
    (form-bind "userdelete" "click" ui-userdel)
    (form-bind "user" "change" update-users)
    (form-bind "sn" "change" not_saved)
    (form-bind "givenname" "change" not_saved)
    (form-bind "patronym" "change" not_saved)
    (form-bind "homedirectory" "change" not_saved)
    (form-bind "loginshell" "change" not_saved)
    (form-bind "passwd_auto" "change" not_saved)
    (form-bind "passwd_1" "change" not_saved)
    (form-bind "o" "change" not_saved)
    (form-bind "ou" "change" not_saved)
    (form-bind "title" "change" not_saved)
    (form-bind "title_list" "change" not_saved)
    (form-bind "telephonenumber" "change" not_saved)
    (form-bind "mobile" "change" not_saved)
    (form-bind "departmentnumber" "change" not_saved)
    (form-bind "departmentnumber_list" "change" not_saved)
    (form-bind "postaladdress" "change" not_saved)
    (form-bind "rem_host" "change" read_rem_bases)
    (form-bind "add_to_group" "click" ui-add-to-group)
    (form-bind "migration" "click" on-migrate)
    (form-bind "remove_from_group" "click" ui-del-from-group)
    (form-bind "filter" "click" filtered_userlist)
    (form-bind "select_btn" "click" select_other)
    (form-bind "useit_btn" "click" other_selected)
    (form-bind "ret_list" "click" return_to_list)
    (form-bind "set_photo" "click" show-upload)
    (form-bind "del_photo" "click" photo_del)
    (form-bind "cansel_photo" "click" hide-upload)
    (form-bind-upload "upload_photo" "click" "photo_file" on-upload)
    (form-bind "bind_btn" "click" set_bind)
)
