(define-module (ui net-bl ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :use-module (alterator algo)
    :export (init))

(define (read)
  (catch/message (lambda ()
    (form-update-enum "ip" (woo-list "/net-bl"))
    (form-update-value-list
      '("status" "ip" "commit_mode") (woo-read-first "/net-bl")) )))

(define (switch)
  (catch/message (lambda ()
    (woo "switch" "/net-bl" 'status (form-value "status")))))

(define (add)
  (catch/message (lambda ()
    (woo "add" "/net-bl" 'new_ip (form-value "new_ip")) ))
  (form-update-value "new_ip" "")
  (read))

(define (del)
  (catch/message (lambda ()
    (woo "del" "/net-bl"
      'ip (form-value "ip") )))
  (read))

(define (init)
  (read)
  (form-update-visibility "manmode_warn" (string=? "off" (form-value "commit_mode")))
  (form-bind "status"  "change" switch)
  (form-bind "add"     "click"  add)
  (form-bind "del"     "click"  del) )

