(document:surround "/std/frame")
(po-domain "alterator-net-iptables")

;;; Functions

(define (on-add)
  (woo-catch/message (lambda()
    (woo-try "add" "/net-bl" 'new_ip (new_ip value))
    (ip enumref "net-bl") )))

(define (on-del)
  (woo-catch/message (lambda()
    (woo-try "del" "/net-bl"
      'ip (ip value))
    (ip enumref "net-bl") )))

;;; UI

(gridbox
  columns "40;40;20"
  margin 20

  (checkbox text (_ "Enable blacklist filtering") name "status" colspan 3
    (when changed (woo-try "switch" "/net-bl" 'status (form-value "status"))) )

  (label text (_ "Blacklist:") align "top" colspan 3)

  (document:id ip
    (listbox name "ip" enumref "net-bl" colspan 2))
  (button text (_ "Delete") (when clicked (on-del)) align "top")

  (label text (_ "Add new IP:") colspan 3)

  (label text (_ "Add host or network IP-address:") align "right")
  (document:id new_ip (edit name "new_ip"))
  (button text (_ "Add") (when clicked (on-add)))
)