(define-module (ui net-dnat ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :use-module (alterator algo)
    :export (init))

(define (read)
  (catch/message (lambda ()
    (form-update-enum "rule" (woo-list "/net-dnat/rules"))
    (form-update-value-list
      '("status" "rule" "proto" "ip1" "p1" "ip2" "p2" "commit_mode")
      (woo-read-first "/net-dnat")) )))

(define (switch)
  (catch/message (lambda ()
    (woo "switch" "/net-dnat" 'status (form-value "status")))))

(define (add)
  (catch/message (lambda ()
    (woo "add" "/net-dnat" 
      'proto (form-value "proto")
      'ip1   (form-value "ip1")
      'p1    (form-value "p1")
      'ip2   (form-value "ip2")
      'p2    (form-value "p2") )))
  (read))

(define (del)
  (catch/message (lambda ()
    (woo "del" "/net-dnat"
      'rule (form-value "rule") )))
  (read) )

(define (init)
  (catch/message (lambda ()
    (form-update-enum "proto"
      (woo-list "/net-dnat/protocols"))
    (form-update-enum "ip1"
      (woo-list "/net-dnat/our_ips")) ))
  (read)
  (form-update-visibility "manmode_warn" (string=? "off" (form-value "commit_mode")))
  (form-bind "status"  "change" switch)
  (form-bind "add"     "click"  add)
  (form-bind "del"     "click"  del) )

