(document:surround "/std/frame")
(po-domain "alterator-net-iptables")

;;; Functions

(define (on-add)
  (woo-catch/message (lambda()
    (woo-try "add" "/net-dnat"
      'proto (proto value)
      'ip1 (ip1 value)
      'p1  (p1 value)
      'ip2 (ip2 value)
      'p2  (p2 value))
    (rules enumref "net-dnat/rules") )))

(define (on-del)
  (woo-catch/message (lambda()
    (woo-try "del" "/net-dnat"
      'rule (rules value))
    (rules enumref "net-dnat/rules") )))

;;; UI

(gridbox
  columns "99;1"
  margin 20

  (checkbox text (_ "Enable port forwarding") name "status" colspan 2
    (when changed (woo-try "switch" "/net-dnat" 'status (form-value "status"))) )

  (label text (_ "Available rules:") align "top" colspan 2)

  (document:id rules
    (listbox name "rules" enumref "net-dnat/rules"))
  (button text (_ "Delete") (when clicked (on-del)) align "top")

  (label text (_ "Add new rule:") colspan 2)

  (gridbox columns "44;44;2;10"

    (spacer)
    (gridbox columns "50;50"
      (label text (_ "protocol:") align "right")
      (document:id proto
        (combobox name "proto" enumref "net-dnat/protocols")) )
    (spacer)
    (spacer)

    (label text (_ "destination IP address:") align "right")
    (document:id ip1 (combobox name "ip1" enumref "net-dnat/our_ips"))
    (label text (_ "port:") align "right")
    (document:id p1 (edit name "p1"))

    (label text (_ "forward to IP address:") align "right")
    (document:id ip2 (edit name "ip2"))
    (label text (_ "port:") align "right")
    (document:id p2 (edit name "p2"))
  )
  (button text (_ "Add") (when clicked (on-add)))
)