(define-module (ui net-domain ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :use-module (alterator effect)
    :export (on-load))

(define *resolver* "unknown")
(define *access* "unknown")
(define *ldap* "unknown")
(define *kdc* "unknown")
(define *smb* "unknown")
(define *dhcpd* "unknown")
(define *master* "off")

(define (ui-read)
  (catch/message
    (lambda()
      (form-update-value-list '("domain")
			      (woo-read-first "/net-domain"))
      (let* ((data (woo-read"/net-domain" )))
	(set! *resolver* (woo-get-option (car data) 'resolver))
	(set! *access* (woo-get-option (car data) 'access))
	(set! *ldap* (woo-get-option (car data) 'ldap))
	(set! *kdc* (woo-get-option (car data) 'kdc))
	(set! *smb* (woo-get-option (car data) 'smb))
	(set! *dhcpd* (woo-get-option (car data) 'dhcpd))
	(set! *master* (woo-get-option (car data) 'master))
	) 
      (form-update-value "resolver" *resolver*)
      (form-update-value "access" *access*)
      (form-update-value "ldap" *ldap*)
      (form-update-value "kdc" *kdc*)
      (form-update-value "smb" *smb*)
      (form-update-value "dhcpd" *dhcpd*)
      (form-update-value "master" *master*)
      )))

(define (ui-write)
  (catch/message
    (lambda()
      (woo-write "/net-domain"
		 'language (form-value "language")
		 'master (form-value "master")
		 'domain (form-value "domain"))
      (ui-read)
      )))

(define (on-load)
  (ui-read)
  (effect-hide "status-page" "master" #f)
  (init-effect)
  (form-bind "submit" "click" ui-write)
  (form-bind "reset" "click" ui-read))

