(define-module (ui net-iptables-manual ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :use-module (alterator card-index)
    :export (init))

(define (hide-buttons)
  (form-update-visibility "reset" (form-value "status"))
  (form-update-visibility "apply" (form-value "status"))
)

(define (ui-read)
  (let ((name (f-get-ci-value "name") ))
    (f-reset "/net-iptables-manual" 'name name))
  (hide-buttons))

(define (ui-write)
  (let ((name (f-get-ci-value "name") ))
    (f-submit "/net-iptables-manual" 'name name))
  (ui-read))

(define (ui-switch)
  (catch/message (lambda ()
    (woo "switch" "/net-iptables-manual" 'status (form-value "status"))))
  (ui-read))

(define (init)
  (f-update-ci-list "name" "/net-iptables-manual")
  (ui-read)
  (form-bind "status"  "change" ui-switch)
  (form-bind "name"    "change" ui-read)
  (form-bind "reset"   "click"  ui-read)
  (form-bind "apply"   "click"  ui-write))
