(document:surround "/std/frame")

;;; Functions

(define (read-from-backend)
  (woo-catch/message (lambda()
      (let ((data (woo-read-first "/net-iptables")))
	(ifaces    value (woo-get-option data 'external_ifaces))
	(services  value (woo-get-option data 'opened_services))
	(tcp-ports value (woo-get-option data 'opened_tcp_ports))
	(udp-ports value (woo-get-option data 'opened_udp_ports))
	(gw state (string=? (woo-get-option data 'mode) "gateway"))
	(fw state (string=? (woo-get-option data 'mode) "router")) ))))

(define (write-to-backend)
  (woo-catch/message (lambda()
    (woo-write "/net-iptables"
      'mode (if (gw state) "gateway" "router")
      'external_ifaces (ifaces value)
      'opened_services (services value)
      'opened_tcp_ports (tcp-ports value)
      'opened_udp_ports (udp-ports value) ))))

;;; UI

(gridbox
  columns "50;50"
  margin 20

  (label text (_ "Select forwarding mode:") align "top" rowspan 2)
  (document:id fw (radio text (_ "router")))
  (document:id gw (radio text (_ "gateway")))

  (separator colspan 2)

  (label text (_ "Select external interfaces:"))
  (label text (_ "Allow incoming connections on external interfaces:") align "center")

  (document:id ifaces
    (checklistbox name "ifaces" enumref "net-iptables/ifaces") )

  (gridbox columns "100"

    (label text (_ "Services:"))
    (document:id services
      (checklistbox name "service" enumref "net-iptables/services"))

    (label text (_ "Extra TCP ports:"))
    (document:id tcp-ports (edit name "tcp_ports"))
    (label text (_ "(separated by commas or spaces)"))

    (label)
    (label text (_ "Extra UDP ports:"))
    (document:id udp-ports (edit name "udp_ports"))
    (label text (_ "(separated by commas or spaces)"))
  )

  ;;
  (label)
  (hbox align "center"
    (button text (_ "Apply")
      (when clicked (write-to-backend) (read-from-backend)))
    (label "  ")
    (button text (_ "Reset")
      (when clicked (read-from-backend))) ) )


(document:root (when loaded (read-from-backend)))
