(define-module (ui net-openvpn ajax)
			   :use-module (alterator ajax)
			   :use-module (alterator woo)
			   :export (init))

(define (ui-update-activity active)
  (form-update-activity "info" active)
  (form-update-activity "status" active)
  (form-update-activity "server" active)
  (form-update-activity "port" active)
  (form-update-activity "keys" active)
  (form-update-activity "onboot" active)
  (form-update-activity "def_via_vpn" active)
  (form-update-activity "lzo" active)
  (form-update-activity "use_tcp" active)
  (form-update-activity "apply" active)
  (form-update-activity "reset" active)
  (form-update-activity "delete" active))

(define (read-connections)
  (let ((connections (woo-list "/net-openvpn/avail_connections")))
    (form-update-enum "connections" connections)
    (ui-update-activity (not (null? connections)))))

(define (update-keys-list)
  (form-update-enum "keys" (woo-list "/net-openvpn/avail_keys")))

(define (read-config)
  (let ((cmd (woo-read-first "/net-openvpn"
                             'dev (form-value "connections") 'language (form-value "language"))))
    (and cmd
         (form-update-value-list
           '("connections" "info" "server" "port" "keys" "onboot" "def_via_vpn" "lzo" "use_tcp")
           cmd))))

(define (init-interface)
  (form-update-visibility "ca_upload_message" #f)
  (form-update-enum "status" (woo-list "/net-openvpn/avail_state" 'language (form-value "language")))
  (update-keys-list)
  (read-connections)
  (read-config)
  (form-update-value "dev_type" "tun"))

(define (write-config)
  (let ((dev (form-value "connections")))
	(and
	  dev
	  (catch/message
		(lambda()
		  (apply woo-write
				 "/net-openvpn"
				 'commit #t
				 'dev dev
				 (form-value-list
				   '("status" "server" "port" "keys" "onboot" "def_via_vpn" "lzo" "use_tcp")))))
	  (read-config))))

(define (new-connection)
  (and
	(catch/message
	  (lambda()
		(woo-write
		  "/net-openvpn"
		  'new #t
		  'dev_type (form-value "dev_type"))))
	(begin
	  (read-connections)
	  (read-config))))

(define (delete-connection)
  (let ((dev (form-value "connections")))
	(and
	  dev
	  (catch/message
		(lambda()
		  (woo-write
			"/net-openvpn"
			'delete #t
			'dev dev)))
	  (begin
		(read-connections)
		(read-config)))))

(define (upload-ca-interface)
  (form-replace "/net-openvpn/ca"))

(define (keys-interface)
  (form-replace "/sslkey"))

(define (on-upload)
  (form-update-visibility "ca_upload_message" #f)
  (call-with-form-file
    "ca_cert"
    (lambda(path)
      (and
        (catch/message
          (lambda() (woo-write "/net-openvpn/import-ca" 'path path 'language (form-value "language"))))
        (form-update-visibility "ca_upload_message" #t)))))

(define (init)
  (init-interface)
  (form-bind-upload "upload_button" "click" "ca_cert" on-upload)
  (form-bind "new_connection" "click" new-connection)
  (form-bind "connections" "change" read-config)
  (form-bind "keys_managament" "click" keys-interface)
  (form-bind "apply" "click" write-config)
  (form-bind "reset" "click" read-config)
  (form-bind "delete" "click" delete-connection))

