(document:surround "/std/frame")

;;; Functions
(define (ui-update-activity active)
  (form-update-activity "info" active)
  (form-update-activity "status" active)
  (form-update-activity "server" active)
  (form-update-activity "port" active)
  (form-update-activity "keys" active)
  (form-update-activity "onboot" active)
  (form-update-activity "def_via_vpn" active)
  (form-update-activity "lzo" active)
  (form-update-activity "use_tcp" active)
  (form-update-activity "apply" active)
  (form-update-activity "reset" active)
  (form-update-activity "delete" active))

(define (read-connections)
  (let ((connections (woo-list "/net-openvpn/avail_connections")))
    (form-update-enum "connections" connections)
    (ui-update-activity (not (null? connections)))))

(define (update-keys-list)
  (form-update-enum "keys" (woo-list "/net-openvpn/avail_keys")))

(define (read-config)
  (let ((cmd (woo-read-first "/net-openvpn"
                             'dev (form-value "connections") 'language (form-value "language"))))
    (and cmd
         (form-update-value-list
           '("connections" "info" "server" "port" "keys" "onboot" "def_via_vpn" "lzo" "use_tcp")
           cmd))))

(define (init-interface)
  (form-update-enum "status" (woo-list "/net-openvpn/avail_state" 'language (form-value "language")))
  (update-keys-list)
  (read-connections)
  (read-config)
  (form-update-value "dev_type" "tun"))

(define (write-config)
  (let ((dev (form-value "connections")))
	(and
	  dev
	  (catch/message
		(lambda()
		  (apply woo-write
				 "/net-openvpn"
				 'commit #t
				 'dev dev
				 (form-value-list
				   '("status" "server" "port" "keys" "onboot" "def_via_vpn" "lzo" "use_tcp")))))
	  (read-config))))

(define (new-connection)
  (and
	(catch/message
	  (lambda()
		(woo-write
		  "/net-openvpn"
		  'new #t
		  'dev_type (form-value "dev_type"))))
	(begin
	  (read-connections)
	  (read-config))))

(define (delete-connection)
  (let ((dev (form-value "connections")))
	(and
	  dev
	  (catch/message
		(lambda()
		  (woo-write
			"/net-openvpn"
			'delete #t
			'dev dev)))
	  (begin
		(read-connections)
		(read-config)))))

(define (on-import)
  (let ((path (import-ca value)))
    (or (string=? path "")
        (and
          (catch/message
            (lambda()
              (woo-write
                "/net-openvpn/import-ca"
                'path path)))
          (import-ca value "")))))

(define (keys-interface)
  (form-replace "/sslkey"))

;;; UI
(define fileselect (make-widget 'fileselect))
(define url (make-attribute 'url))
(define value (make-attribute 'value))
(define filter (make-attribute 'filter))
(define hints (make-attribute 'hints))

(gridbox
  columns "0;100"
  margin 20

  (label colspan 2 text (bold (_ "New connection:")))
  (gridbox
	colspan 2
	columns "0;40;150"
	(radio name "dev_type" align "left" value "tun" colspan 2 text (_ "Network tunnel (TUN)"))
	(spacer)
	(radio name "dev_type" align "left" value "tap" colspan 2 text (_ "Virtual Ethernet device (TAP)"))
	(spacer)
    (button (_ "Create connection") name "new_connection")
	(spacer))
  (separator colspan 2)
  (spacer colspan 2)

  (splitbox
	colspan 2
	columns "30;70"

  (listbox name "connections")

  (gridbox
	colspan 2
	columns "0;40;60"

	(label text (_ "Status:") align "right")
	(hbox align "left"
		  (label name "info")
		  (combobox name "status"))
	(spacer)
	;;
	(label text (_ "Server:") name "server" align "right")
	(edit name "server")
	(spacer)
	;;
	(label text (_ "Port:") name "port" align "right")
	(edit name "port")
	(spacer)
	;;
	(label text (_ "Key:") name "keys" align "right")
	(combobox name "keys")
	(spacer)
    ;;
    (spacer)
    (hbox align "left"
          colspan 2
          (button (_ "Keys managament...") name "keys_managament"))
    (spacer)
	;;
	(checkbox text (_ "Start at boot") name "onboot")
	(spacer)
	;;
	(spacer)
	(checkbox text (_ "Default route via VPN") name "def_via_vpn")
	(spacer)
	;;
	(spacer)
	(checkbox text (_ "LZO compression") name "lzo")
	(spacer)
	;;
	(spacer)
	(checkbox text (_ "Use a TCP connection") name "use_tcp")
	(spacer)
	;;
  (spacer)
  (hbox align "left"
        colspan 2
        (button (_ "Apply") name "apply")
        (button (_ "Reset") name "reset")
        (spacer)(spacer)(spacer)(spacer)
        (button (_ "Delete connection") name "delete"))))

  (separator colspan 2)
  ;;
  (hbox align "left"
        colspan 2
        (label text (_ "Import CA certificate:"))
        (document:id import-ca (fileselect title (_"Import CA certificate")
                                           url "/"
                                           filter "*.cert *.crt *.pem"
                                           hints "existing_file"))
        (button (_ "Import") name "import_button")))

;;;;;;;;;;;;;;;;;;

(document:root 
  (when loaded (init-interface))
  (form-bind "new_connection" "click" new-connection)
  (form-bind "connections" "change" read-config)
  (form-bind "keys_managament" "click" keys-interface)
  (form-bind "apply" "click" write-config)
  (form-bind "reset" "click" read-config)
  (form-bind "delete" "click" delete-connection)
  (form-bind "import_button" "click" on-import))

