(define-module (ui net-routing ajax)
    :use-module (alterator str)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :export (init))

(define (update-view)
  (catch/message (lambda()
    (form-update-value "view" (woo-get-option (woo-read-first "/net-routing") 'view)))))

(define (update-list)
  (catch/message (lambda()
    (form-update-enum "setlist"
      (apply woo "routes" "/net-routing"
        (form-value-list '("language")) )))))

(define (do_delete)
  (catch/message (lambda()
    (apply woo "delete" "/net-routing"
      (form-value-list '("language" "setlist")) )))
  (update-list))

(define (do_add)
  (catch/message (lambda()
    (apply woo "add" "/net-routing"
      (form-value-list '("language" "interface" "src_net" "src_mask" "dst_interface" "dst_ip" "metric")) )))
  (update-list))

(define (do_change)
  (catch/message (lambda()
    (apply woo "change" "/net-routing"
      (form-value-list '("language" "interface" "src_net" "src_mask" "dst_interface" "dst_ip" "metric" "setlist")) )))
  (update-list))

(define (do_apply)
  (catch/message (lambda()
    (apply woo "apply" "/net-routing"
      (form-value-list '("language")) )))
  (update-list)
  (update-view)
)

(define (do_reset)
  (catch/message (lambda()
    (apply woo "reset" "/net-routing"
      (form-value-list '("language")) )))
  (update-list))

(define (on_select_route)
  (catch/message (lambda()
    (form-update-value-list '("interface" "src_net" "src_mask" "dst_interface" "dst_ip" "metric")
      (apply woo "select" "/net-routing"
        (form-value-list '("language" "setlist")) ))))
)

(define (init)
    (do_reset)

    (form-update-enum "interface" (woo-list "/net-routing/ifaces"))
    (form-update-enum "src_mask" (woo-list "/net-eth/avail_masks"))
    (form-update-value "src_mask" "24")
    (form-update-enum "dst_interface" (woo-list "/net-routing/ifaces"))
    ;(form-update-value "metric" "0")

 (form-bind "setlist" "click" on_select_route)

 (form-bind "btn_view_update"  "click" update-view)
 (form-bind "btn_change" "click" do_change)

 (form-bind "btn_delete" "click" do_delete)
 (form-bind "btn_add"    "click" do_add)
 (form-bind "btn_apply"  "click" do_apply)
 (form-bind "btn_reset"  "click" do_reset)
)

