(document:surround "/std/frame")

(gridbox margin 10
    (gridbox columns "100;0;100"
	(separator)(label (_ "View"))(separator)
    )

    (gridbox columns "100;0"
	(textbox name "view" rowspan 4 alterability #f)
	(button text (_ "Update") name "btn_view_update")
    )

    (gridbox columns "100;0;100"
	(separator)(label (_ "Setup"))(separator)
    )

    (gridbox
	(gridbox columns "100;0"
	    (listbox name "setlist" rowspan 4)
	    (button text (_ "Delete") name "btn_delete")
	)
    )

    (gridbox columns "100;0;100"
	(separator)(label (_ "Edit route"))(separator)
    )

	(gridbox columns "25;50;25"
	    (label (_ "Interface:") align "right")
	    (gridbox columns "50;50"
		(combobox name "interface")
		(spacer)
	    )
	    (button text (_ "Add") name "btn_add" align "left")

	    (label (_ "Source:") align "right")
	    (gridbox columns "50;50"
		(edit name "src_net")
		(combobox name "src_mask")
	    )
	    (button text (_ "Change") name "btn_change" align "left")

	    (label (_ "Destination:") align "right")
	    (gridbox columns "50;50"
		(edit name "dst_ip")
		(combobox name "dst_interface")
	    )
	    (spacer)

	    (label (_ "Metric:") align "right")
	    (gridbox columns "50;50"
		(spinbox name "metric" step 1 minimum 0 maximum 255)
	    )
	    (spacer)
	)

    (gridbox columns "100;0;0;100" margin 15 colspan 3
	(spacer)
	(button text (_ "Apply") name "btn_apply")
	(button text (_ "Reset") name "btn_reset")
	(spacer)
    )
)

;;;;;;;;;;;;;;;; copy of ajax.scm

(define (update-view)
  (catch/message (lambda()
    (form-update-value "view" (woo-get-option (woo-read-first "/net-routing") 'view)))))

(define (update-list)
  (catch/message (lambda()
    (form-update-enum "setlist"
      (apply woo "routes" "/net-routing"
        (form-value-list '("language")) )))))

(define (do_delete)
  (catch/message (lambda()
    (apply woo "delete" "/net-routing"
      (form-value-list '("language" "setlist")) )))
  (update-list))

(define (do_add)
  (catch/message (lambda()
    (apply woo "add" "/net-routing"
      (form-value-list '("language" "interface" "src_net" "src_mask" "dst_interface" "dst_ip" "metric")) )))
  (update-list))

(define (do_change)
  (catch/message (lambda()
    (apply woo "change" "/net-routing"
      (form-value-list '("language" "interface" "src_net" "src_mask" "dst_interface" "dst_ip" "metric" "setlist")) )))
  (update-list))

(define (do_apply)
  (catch/message (lambda()
    (apply woo "apply" "/net-routing"
      (form-value-list '("language")) )))
  (update-list)
  (update-view)
)

(define (do_reset)
  (catch/message (lambda()
    (apply woo "reset" "/net-routing"
      (form-value-list '("language")) )))
  (update-list))

(define (on_select_route)
  (catch/message (lambda()
    (form-update-value-list '("interface" "src_net" "src_mask" "dst_interface" "dst_ip" "metric")
      (apply woo "select" "/net-routing"
        (form-value-list '("language" "setlist")) ))))
)

(define (init)
    (do_reset)

    (form-update-enum "interface" (woo-list "/net-routing/ifaces"))
    (form-update-enum "src_mask" (woo-list "/net-eth/avail_masks"))
    (form-update-value "src_mask" "24")
    (form-update-enum "dst_interface" (woo-list "/net-routing/ifaces"))
    ;(form-update-value "metric" "0")

 (form-bind "setlist" "click" on_select_route)

 (form-bind "btn_view_update"  "click" update-view)
 (form-bind "btn_change" "click" do_change)

 (form-bind "btn_delete" "click" do_delete)
 (form-bind "btn_add"    "click" do_add)
 (form-bind "btn_apply"  "click" do_apply)
 (form-bind "btn_reset"  "click" do_reset)
)


(document:root (when loaded (init)))
