(define-module (ui net-tc ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :use-module (alterator algo)
    :export (init))

(define (read)
  (let ((name (or (form-value "name") "default")))
    (catch/message (lambda ()
      (form-update-enum "name" (woo-list "/net-tc" 'language (form-value "language")))
      (form-update-value-list
        '("status" "ifaces" "mac" "ikbps" "okbps" "services" "tcp_ports" "udp_ports" "commit_mode")
        (woo-read-first "/net-tc" 'name name 'language (form-value "language") )) ))
    (form-update-value "ip"   name)
    (form-update-value "name" name)
    (let ((ndef (not (string=? "default" name))))
      (form-update-value "allowed_conn_label"
        (if ndef
          (_ "Additional allowed connections:" "alterator-net-iptables")
          (_ "Allowed connections for all authorized clients:" "alterator-net-iptables") ))
      (form-update-visibility "del" ndef)
      (form-update-visibility "ip" ndef)
      (form-update-visibility "tc" ndef)
      (form-update-visibility "ikbps" ndef)
      (form-update-visibility "okbps" ndef)
      (form-update-visibility "resolve" ndef)
      (form-update-visibility "mac" ndef) )))

(define (switch)
  (catch/message (lambda ()
    (woo "switch" "/net-tc" 'status (form-value "status")))))

(define (resolve)
  (catch/message (lambda ()
    (form-update-value "mac"
      (woo-get-option
        (cond-car
          (woo "resolve" "/net-tc" 'name (form-value "name")))
         'mac "")))))

(define (add)
  (catch/message (lambda ()
    (woo "add" "/net-tc" 'new_ip (form-value "new_ip") )))
  (form-update-value "name" (form-value "new_ip"))
  (form-update-value "new_ip" "")
  (read) )

(define (del)
  (catch/message (lambda ()
    (woo "del" "/net-tc" 'name (form-value "name") )))
  (form-update-value "name" "default")
  (read) )

(define (app)
  (catch/message (lambda ()
    (apply woo-write "/net-tc" (form-value-list
      '("language" "services" "tcp_ports" "udp_ports" "name" "mac" "ikbps" "okbps")))
  )))

(define (init)
  (catch/message (lambda ()
    (form-update-enum "services"
      (woo-list "/net-iptables/services" 'language (form-value "language")))))
  (read)
  (form-update-visibility "manmode_warn" (string=? "off" (form-value "commit_mode")))
  (form-bind "name"    "change" read)
  (form-bind "status"  "change" switch)
  (form-bind "resolve" "click"  resolve)
  (form-bind "add"     "click"  add)
  (form-bind "del"     "click"  del)
  (form-bind "apply"   "click"  app))
