(define-module (ui net-wifi ajax)
    :use-module (alterator ajax)
    :use-module (alterator woo)
    :use-module (alterator card-index)
    :use-module (alterator algo)
    :export (init))

(define (ui-read)
  (f-reset  "/net-wifi" 'iface (form-value "iface") 'name (form-value "name"))
  (update-activity))

(define (update-networks)
  (f-update-ci-list "name" "/net-wifi/networks" 'iface (form-value "iface"))
  (ui-read) )

(define (ui-write)
  (f-submit "/net-wifi" 'iface (form-value "iface") 'btn_apply ".")
  (update-networks))


(define (update-status)
  (form-update-value-list `("iface_status")
    (woo-read-first "/net-wifi" 'iface (form-value "iface")))
;  (form-set-timeout update-status 2))
)

(define (update-activity)
  (let ((auth (form-value "auth_type")))
    (form-update-activity "key"      (not (string=? auth "nopasswd")) )
    (form-update-activity "pairwise" (not (or (string=? auth "nopasswd")
                                            (string=? auth "wep")))) ))

;;;

(define (ui-reconfigure)
  (catch/message (thunk
    (woo-write "/net-wifi" 'iface (form-value "iface") 'btn_reconfigure "." )))
  (update-networks) )

(define (ui-delete)
  (catch/message (thunk
    (woo-write "/net-wifi" 'iface (form-value "iface")
                           'name (form-value "name")
                           'btn_delete "." )))
  (update-networks) )

(define (ui-rescan)
  (catch/message (thunk
    (woo-write "/net-wifi" 'iface (form-value "iface") 'btn_rescan "." )
    (f-update-list "scan-results" "/net-wifi/scan_results" 'iface (form-value "iface"))) ))

(define (ui-new)
   (catch/message (thunk
    (woo-write "/net-wifi" 'iface (form-value "iface")
                           'btn_new "."
                           'scanned_net (form-value "scan-results"))))
    (update-networks) )

;;;


(define (init)
  (form-bind "name"      "change"  update-networks)
  (form-bind "auth_type" "change"  update-activity)

  (form-bind "btn_reconfigure" "click" ui-reconfigure)
  (form-bind "btn_apply"       "click" ui-write)
  (form-bind "btn_reset"       "click" ui-read)
  (form-bind "btn_delete"      "click" ui-delete)
  (form-bind "btn_rescan"      "click" ui-rescan)
  (form-bind "btn_new"         "click" ui-new)

  (f-update-list "auth_type" "/net-wifi/auth_types"     'iface (form-value "iface"))
  (f-update-list "pairwise"  "/net-wifi/pairwise_types" 'iface (form-value "iface"))
  (update-networks)
  (ui-rescan)
  (update-status) )



