(document:surround "/std/frame")
(document:insert "/std/functions")

(define *iface* (global 'iface))
(define *networks* (make-cell '()))


(define (update-networks)
  (catch/message (thunk
    (cell-set! *networks*  (woo-list "/net-wifi/networks" 'iface *iface*))))
  (let ((n (form-value "networks")))
    (form-update-enum "networks" (cell-ref *networks*))
    (form-update-value "networks" n))
  (if (string=? "" (form-value "networks"))
    (if (pair? (cell-ref *networks*))
      (form-update-value "networks"
        (woo-get-option (car (cell-ref *networks*)) 'name) ))))

(define (reset-from-backend)
  (catch/message (thunk
    (let ((data
        (woo-read-first "/net-wifi" 'iface *iface* 'name (form-value "networks"))))
      (form-update-value "iface"     (bold *iface*))
      (form-update-value "current"   (bold (woo-get-option data 'current)))
      (form-update-value "status"    (woo-get-option data 'iface_status))
      (form-update-value "enable-cb" (woo-get-option data 'enabled))
      (form-update-value "essid"     (woo-get-option data 'essid ""))
      (form-update-value "auth_type" (woo-get-option data 'auth_type))
      (form-update-value "key"       "")
      (form-update-value "pairwise"  (woo-get-option data 'pairwise ""))
      (update-activity) ))))

(define (write-to-backend)
  (catch/message
    (thunk (woo-write "/net-wifi"
      'btn_apply "."
      'iface *iface*
      'enabled   (form-value "enable-cb")
      'essid     (form-value "essid")
      'auth_type (form-value "auth_type")
      'key       (form-value "key")
      'pairwise  (form-value "pairwise")
      'name      (form-value "networks"))
    (update-networks)
    (reset-from-backend))))



(define (update-activity)
  (let ((auth (form-value "auth_type")))
    (form-update-activity "key"      (not (string=? auth "nopasswd")) )
    (form-update-activity "pairwise" (not (or (string=? auth "nopasswd")
                                            (string=? auth "wep")))) ))

;;;

(define (ui-reconfigure)
  (catch/message (thunk
    (woo-write "/net-wifi" 'iface *iface* 'btn_reconfigure "." )))
  (update-networks)
  (reset-from-backend))

(define (ui-delete)
  (catch/message (thunk
    (woo-write "/net-wifi" 'iface *iface*
                           'name (form-value "networks")
                           'btn_delete "." )))
  (update-networks)
  (reset-from-backend) )

(define (ui-rescan)
  (catch/message (thunk
    (woo-write "/net-wifi" 'iface *iface* 'btn_rescan "." )
    (form-update-enum "scan-results" (woo-list "/net-wifi/scan_results" 'iface *iface*)) )))

(define (ui-new)
   (catch/message (thunk
    (woo-write "/net-wifi" 'iface *iface*
                           'btn_new "."
                           'scanned_net (form-value "scan-results"))))
    (update-networks)
    (reset-from-backend) )

;;; widgets!

(gridbox columns "0;100"

  (label (_ "Interface:") nameref "iface")
  (label name "iface")

  (label (_ "Status:") nameref "status")
  (label name "status" text-wrap #t)

  (spacer)
  (button align "right" text (_ "Reconfigure interface") (when clicked (ui-reconfigure))))

(groupbox (_ "Configured networks")

  (gridbox columns "30;70"

    (listbox name "networks" (when selected (reset-from-backend) ))
    (gridbox columns "0;100"

      (spacer)
      (label name "current")

      (spacer)
      (checkbox text (_ "Enable") name "enable-cb")

      (label (_ "Network name:") nameref "essid")
      (edit name "essid")

      (label (_ "Auth type:") nameref "auth_type")
      (combobox name "auth_type" (when selected (update-activity)))

      (label (_ "Change password:") nameref "key")
      (edit "" name "key")

      (label (_ "Encryption:") nameref "pairwise")
      (combobox name "pairwise")

      (spacer)
      (gridbox columns "100;0;0;0" (spacer)
        (button text (_ "Apply") (when clicked (write-to-backend)))
        (button text (_ "Reset") (when clicked (reset-from-backend)))
        (button text (_ "Delete") (when clicked (ui-delete))))
  )))

(label (string-append "<b>" (_ "Configure new network") "</b>"))

(gridbox columns "0;100;0;0"
  (label (_ "Networks found:"))
  (combobox name "scan-results")
  (button text (_ "Rescan") (when clicked (ui-rescan)))
  (button text (_ "Configure") (when clicked (ui-new))))

(button (_ "OK")
  align "left"
  (when clicked
    (woo-try "monitor" "/net-wifi" 'mode "off")
    (remove-mailbox message-handler)
    (document:end)))

;;;


(define (message-handler args)
  (and (eq? (car args) 'wpa-supplicant)
    (catch/message (lambda()
      (update-networks)
      (form-update-value "status"
        (woo-get-option
          (woo-read-first "/net-wifi" 'iface *iface*) 'iface_status))))))

(document:root (when loaded
  (catch/message (thunk
    (form-update-enum "auth_type" (woo-list "/net-wifi/auth_types" 'iface *iface*))
    (form-update-enum "pairwise"  (woo-list "/net-wifi/pairwise_types" 'iface *iface*)) ))
  (ui-rescan)
  (update-networks)
  (reset-from-backend)
  (woo-try "monitor" "/net-wifi" 'mode "on")
  (add-mailbox message-handler)
))


