(define-module (ui openldap ajax)
    :use-module (alterator woo)
    :use-module (alterator ajax)
    :use-module (alterator str)
    :use-module (alterator card-index)
    :export (init))

(define *have-ldif* "no")
(define *samba* "No")
(define *mode* "RO")

(define (check_samba)
    (let* ((data (woo "check" "/openldap/" )))
            (set! *samba* (woo-get-option (car data) 'samba3)))
    (if (equal? *samba* "Yes") (set! *mode* "RW"))
)

(define (repair_samba)
    (let* ((data (woo "repair" "/openldap/" )))
            (set! *samba* (woo-get-option (car data) 'samba3)))
    (ui-init)
)

(define (read_only)
   (set! *mode* "RO")
   (form-update-visibility '("ro_info") #t )
   (form-update-activity '("newdn_btn" "expert_dn_btn") #f )
   (ui-init)
)

(define (read_ports)
    (form-update-value-list
      '("daemon" "daemon_state" "local" "enable_tls" "local_and_tls" "key_state") 
    	    (woo-read-first "/openldap/config" 'language (form-value "language"))))

(define (change_daemon)
    (catch/message
	(lambda() (woo-write "/openldap/daemon" 'status (form-value "daemon"))))
    (read_ports)
)

(define (save-main)
    (let ((local (form-value "local"))
          (enable_tls (form-value "enable_tls"))
          (local_and_tls (form-value "local_and_tls")) )
    (woo "save" "/openldap" 'local local 'enable_tls enable_tls 'local_and_tls local_and_tls))
    (read_ports))

(define (newdn)
    (if (string-contains-ci (form-value "newdnname") "?")
    (begin
	(form-update-value "newdnname" (string-append (form-value "newdnname") "?")))
    (begin
	(if (not (string-null? (form-value "newdnname")  ))
	(begin
	    (let ((newdnname (form-value "newdnname")))
    	    (catch/message
    		(lambda()
    		    (woo-new "/openldap/dn" 
    		    'newdnname newdnname 
    		    'language (form-value "language"))
    	    (ui-init)
    	    (form-update-visibility '("new_dn_area") #f )
    	    (form-update-visibility '("list_dn_area") #t )))))
	(begin
	    (form-update-value "newdnname" "?"))))
    )
)

(define (adddn)
    (reset_exp_form)
    (form-update-visibility '("new_dn_area") #t )
    (form-update-visibility '("list_dn_area") #f )
    (form-update-visibility '("config") #f )
    (f-update-list "available_containers" "/openldap/available_containers")
    (f-reset  "/openldap/available_containers")

    (if (string-contains-ci (form-value "newdnname") "?")
	(form-update-value "newdnname" ""))
)

(define (ret_list)
    (form-update-visibility '("new_dn_area") #f )
    (form-update-visibility '("list_dn_area") #t )
    (form-update-visibility '("config") #t )
    (form-update-visibility '("schema_area") #f )
    )
    
(define (show_schema)
    (form-update-visibility '("new_dn_area") #f )
    (form-update-visibility '("list_dn_area") #f )
    (form-update-visibility '("config") #f )
    (form-update-visibility '("schema_area") #t )
)

(define (include_schema)
    (catch/message
    (lambda()
      (woo-write "/openldap/avail_schema" 
      'schemas (form-value "avail_schema"))))
      (ui-init))

(define (ldif_prepare_base)
   (if (not (string-null? (form-value "ldif_file")))
    (call-with-form-file "ldif_file"
	(lambda(path)
	  (catch/message
	    (lambda()
	       (woo-write "/openldap/newldif" 'ldif_file path 
	       'language (form-value "language"))
	         (let* ((data (woo-read "/openldap/fromldif" 
	          'language (form-value "language"))))
    		   (form-update-value-list data))
	       )))))
    (set! *have-ldif* "yes")
)

(define (add_schema)
   (call-with-form-file "schema_file"
	(lambda(path)
	  (catch/message
	    (lambda()
	       (woo-new "/openldap/schema" 'schema_file path 'schema_name (form-value "newschemaname"))
	       ))))
    (form-update-enum "avail_schema" (woo-list "/openldap/avail_schema" 'language (form-value "language")))
    (f-reset  "/openldap/avail_schema")
    (form-update-value "newschemaname" "")
    (form-update-value "schema_file" "")
)

(define (deldn)
  (catch/message
    (lambda()
      (apply woo-delete "/openldap"
             'language (form-value "language")
             (form-value-list '("avail_dn" "name" "conf" "dstat")))
      (ui-init)
      )))

(define (use_encript_pw)
    (let ((status (form-value "encript_pw")))
    (form-update-visibility '("pw_alert") status)))

(define (prepare_base)
    (let ((newdnname (form-value "newfqdnname")))
    (f-reset  "/openldap/base" 'newdnname newdnname )))

(define (change_ports)
   (form-update-value "local" "#f")
   (form-update-value "enable_tls" "#f"))

(define (set_local)
   (form-update-value "local_and_tls" "#f"))
   
(define (reset_exp_form)
    (form-update-visibility '("pw_alert") #f)
    (form-update-value "newfqdnname" "")
    (form-update-value "basedn" "")
    (form-update-value "binddn" "")
    (form-update-value "bindpw" "")
    (form-update-value "encript_pw" "#f")
    (set! *have-ldif* "no")
    (form-update-value "ldif_file" "")
)

(define (addexpert_dn)
    (if (equal? *have-ldif* "no")
    (begin
    (woo "new" "/openldap/exp_dn" 
        'basedn (form-value "basedn")
        'binddn (form-value "binddn")
        'bindpw (form-value "bindpw")
        'encript_pw (form-value "encript_pw")
        'containers (form-value "available_containers")
        'plus_containers (form-value "plus_containers")
        'language (form-value "language")))
    (begin
    (woo "new" "/openldap/fromldif" 
        'bindpw (form-value "bindpw")
        'encript_pw (form-value "encript_pw")
        'language (form-value "language")))
    )
    
    (reset_exp_form)
    (ui-init)
    (form-update-visibility '("new_dn_area") #f )
    (form-update-visibility '("list_dn_area") #t )
)

(define (new_pass)
  (form-update-value-list
    '("bindpw")
    (car (woo "generate" "/openldap")))
)

(define (ui-init)
    (check_samba)
    (if (or (equal? *samba* "Yes") (equal? *mode* "RO"))
      (begin
        (form-update-visibility '("samba_warn") #f )
        (read_ports)
	(form-update-value "newdnname" "")
	(form-update-enum "avail_dn" (woo-list "/openldap/avail_dn" 'language (form-value "language")))
	(form-update-enum "avail_schema" (woo-list "/openldap/avail_schema" 'language (form-value "language")))
	(f-reset  "/openldap/avail_schema")
	(form-update-visibility '("config" "list_dn_area") #t)
	(form-update-visibility '("schema_area" "new_dn_area") #f)
	(if (equal? *mode* "RW") 
	    (begin 
		(form-update-activity '("newdn_btn" "expert_dn_btn") #t)
		(form-update-visibility '("ro_info") #f))
	    (begin
		(form-update-activity '("newdn_btn" "expert_dn_btn") #f)
		(form-update-visibility '("ro_info") #t)) ))
      (begin
        (form-update-visibility '("config" "list_dn_area" ) #f )
        (form-update-visibility '("samba_warn") #t )) )
)

(define (init)
    (ui-init)
    (form-bind "repair" "click" repair_samba)
    (form-bind "readonly" "click" read_only)
    (form-bind "main_btn" "click" save-main)
    (form-bind "newdn_btn" "click" newdn)
    (form-bind "deldn_btn" "click" deldn)
    (form-bind "adddn_btn" "click" adddn)
    (form-bind "expert_dn_btn" "click" addexpert_dn)
    (form-bind "ret_btn" "click" ret_list)
    (form-bind "new_pass_btn" "click" new_pass)
    (form-bind "manage_schema" "click" show_schema)
    (form-bind "schema_btn" "click" include_schema)
    (form-bind-upload "addschema_btn" "click" "schema_file" add_schema)
    (form-bind-upload "prepare_ldif_btn" "click" "ldif_file" ldif_prepare_base)
    (form-bind "newfqdnname" "change" prepare_base)
    (form-bind "encript_pw" "change" use_encript_pw)
    (form-bind "daemon" "change" change_daemon)
    (form-bind "local_and_tls" "change" change_ports)
    (form-bind "local" "change" set_local)
    (form-bind "enable_tls" "change" set_local)
    )

